/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.expr.datastructures;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.List;
import java.util.Objects;

public class Dict
extends Expression {
    static int PRECEDENCE = 170;
    List<Expression> keys;
    List<Expression> values;

    @Override
    public int getPrecedence() {
        return PRECEDENCE;
    }

    public Dict(List<Expression> keys, List<Expression> values) {
        this.keys = keys;
        this.values = values;
        this.setParent();
    }

    private void setParent() {
        if (this.keys != null) {
            for (Expression key : this.keys) {
                if (key == null) continue;
                key.setParent(this);
            }
        }
        if (this.values != null) {
            for (Expression value : this.values) {
                if (value == null) continue;
                value.setParent(this);
            }
        }
    }

    public List<Expression> getKeys() {
        return this.keys;
    }

    public void setKeys(List<Expression> keys) {
        this.keys = keys;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> values) {
        this.values = values;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitDict(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dict dict = (Dict)o;
        return Objects.equals(this.keys, dict.keys) && Objects.equals(this.values, dict.values);
    }

    public int hashCode() {
        return Objects.hash(this.keys, this.values);
    }
}

