/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.compoundStmts;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.expr.atoms.Name;
import io.github.danielnaczo.python3parser.model.stmts.Body;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public class While
extends Statement {
    Expression test;
    Statement body;
    Optional<Statement> orElse;

    public While() {
        this(null, null, null);
    }

    public While(String test) {
        this(new Name(test), null, null);
    }

    public While(Expression test) {
        this(test, null, null);
    }

    public While(String test, Statement body) {
        this(new Name(test), body, null);
    }

    public While(Expression test, Statement body) {
        this(test, body, null);
    }

    public While(Expression test, Statement body, Statement orElse) {
        this.test = test;
        this.body = body;
        this.orElse = Optional.ofNullable(orElse);
        this.setParentToBodies();
    }

    public Expression getTest() {
        return this.test;
    }

    public void setTest(Expression test) {
        this.test = test;
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setParentToBody();
    }

    public Optional<Statement> getOrElse() {
        return this.orElse;
    }

    public void setOrElse(Optional<Statement> orElse) {
        this.orElse = orElse;
        this.setParentToOrElse();
    }

    public Statement addStatement(Statement statement) {
        if (this.body == null) {
            this.body = statement;
            return statement;
        }
        this.body = this.transformStmtToBody();
        Body body = (Body)this.body;
        body.addStatement(statement);
        return statement;
    }

    private Body transformStmtToBody() {
        if (this.body instanceof Body) {
            return (Body)this.body;
        }
        Statement statement = this.body;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(statement);
        Body body = new Body(statements);
        body.setParentStmt(this);
        return body;
    }

    private void setParentToBodies() {
        this.setParentToBody();
        this.setParentToOrElse();
    }

    private void setParentToBody() {
        if (this.body instanceof Body) {
            ((Body)this.body).setParentStmt(this);
        }
    }

    private void setParentToOrElse() {
        Statement orElseStmt;
        if (this.orElse.isPresent() && (orElseStmt = this.orElse.get()) instanceof Body) {
            ((Body)orElseStmt).setParentStmt(this);
        }
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitWhile(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        While aWhile = (While)o;
        return Objects.equals(this.test, aWhile.test) && Objects.equals(this.body, aWhile.body) && Objects.equals(this.orElse, aWhile.orElse);
    }

    public int hashCode() {
        return Objects.hash(this.test, this.body, this.orElse);
    }

    public String toString() {
        return "While";
    }
}

