/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielnaczo.python3parser.model.stmts.smallStmts.assignStmts;

import io.github.danielnaczo.python3parser.model.expr.Expression;
import io.github.danielnaczo.python3parser.model.expr.atoms.Name;
import io.github.danielnaczo.python3parser.model.stmts.Statement;
import io.github.danielnaczo.python3parser.visitors.basic.Python3ASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Assign
extends Statement {
    List<Expression> targets;
    Optional<Expression> value;

    public Assign() {
        this(new ArrayList<Expression>(), null);
    }

    public Assign(Expression value) {
        this(new ArrayList<Expression>(), value);
    }

    public Assign(List<Expression> targets, Expression value) {
        this.targets = targets;
        this.value = Optional.ofNullable(value);
    }

    public List<Expression> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Expression> targets) {
        this.targets = targets;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    public void setValue(Optional<Expression> value) {
        this.value = value;
    }

    public Expression addTarget(Expression expression) {
        this.targets.add(expression);
        return expression;
    }

    public Expression addTargetAsString(String expressionAsString) {
        Name name = new Name(expressionAsString);
        this.targets.add(name);
        return name;
    }

    @Override
    public <R, P> R accept(Python3ASTVisitor<R, P> visitor, P param) {
        return visitor.visitAssign(this, param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assign assign = (Assign)o;
        return Objects.equals(this.targets, assign.targets) && Objects.equals(this.value, assign.value);
    }

    public int hashCode() {
        return Objects.hash(this.targets, this.value);
    }

    public String toString() {
        return "Assign";
    }
}

