/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.dynamo;

import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import io.github.devlibx.easy.database.dynamo.DataSourceFactory;
import io.github.devlibx.easy.database.dynamo.IDynamoHelper;
import io.github.devlibx.easy.database.dynamo.operation.Get;
import io.github.devlibx.easy.database.dynamo.operation.Put;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DynamoHelper
implements IDynamoHelper {
    private final DataSourceFactory dataSourceFactory;

    @Inject
    public DynamoHelper(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    @Override
    public void persist(Put put) {
        DynamoDB client = this.dataSourceFactory.get("default");
        Table table = client.getTable(put.getTable());
        List<AttributeUpdate> attributeUpdates = put.getAttributes().stream().map(attribute -> {
            AttributeUpdate update = new AttributeUpdate(attribute.getName());
            update.put(attribute.getValue());
            return update;
        }).collect(Collectors.toList());
        UpdateItemOutcome outcome = table.updateItem(put.getKeyName(), put.getKeyValue(), put.getSortKeyName(), put.getSortKeyValue(), attributeUpdates.toArray(new AttributeUpdate[0]));
    }

    @Override
    public <T> Optional<T> fineOne(Get get, IDynamoHelper.IRowMapper<T> mapper, Class<T> cls) {
        GetItemSpec spec;
        DynamoDB client = this.dataSourceFactory.get("default");
        Table table = client.getTable(get.getTable());
        Item item = table.getItem(spec = new GetItemSpec().withPrimaryKey(get.getKeyName(), get.getKeyValue(), get.getSortKeyName(), get.getSortKeyValue()).withConsistentRead(get.isConsistentRead()));
        if (item != null) {
            return Optional.ofNullable(mapper.map(item));
        }
        return Optional.empty();
    }

    @Override
    public void execute(String tableName, IDynamoHelper.IDynamoOperation operation) {
        DynamoDB client = this.dataSourceFactory.get("default");
        Table table = client.getTable(tableName);
        operation.process(client, table);
    }
}

