/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.dynamo.demo;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.database.IDatabaseService;
import io.github.devlibx.easy.database.dynamo.IDynamoHelper;
import io.github.devlibx.easy.database.dynamo.config.DynamoConfig;
import io.github.devlibx.easy.database.dynamo.config.DynamoConfigs;
import io.github.devlibx.easy.database.dynamo.module.DatabaseDynamoModule;
import io.github.devlibx.easy.database.dynamo.operation.Get;
import io.github.devlibx.easy.database.dynamo.operation.Put;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoApplication {
    private static final Logger log = LoggerFactory.getLogger(DemoApplication.class);
    private final String TABLE_NAME = "dynamo_demo_app";

    public static void main(String[] args) {
        DemoApplication application = new DemoApplication();
        application.setup();
        System.out.println("Create a table...");
        application.createTable();
        System.out.println("Put a record in db..");
        StringObjectMap response = application.addItemToTable();
        System.out.println("Get a record in db..");
        ClientObject co = application.getItemFromTable(response);
        System.out.println("Result: " + String.valueOf(co));
    }

    private void setup() {
        final DynamoConfig dynamoConfig = new DynamoConfig();
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(this){

            protected void configure() {
                super.configure();
                DynamoConfigs configs = new DynamoConfigs();
                configs.addConfig(dynamoConfig);
                this.bind(DynamoConfigs.class).toInstance((Object)configs);
            }
        }, new DatabaseDynamoModule()});
        ApplicationContext.setInjector((Injector)injector);
        IDatabaseService databaseService = (IDatabaseService)injector.getInstance(IDatabaseService.class);
        databaseService.startDatabase();
    }

    private void createTable() {
        IDynamoHelper helper = (IDynamoHelper)ApplicationContext.getInstance(IDynamoHelper.class);
        CreateTableRequest request = new CreateTableRequest().withAttributeDefinitions(new AttributeDefinition[]{new AttributeDefinition("id", ScalarAttributeType.S), new AttributeDefinition("scope", ScalarAttributeType.S)}).withKeySchema(new KeySchemaElement[]{new KeySchemaElement("id", KeyType.HASH), new KeySchemaElement("scope", KeyType.RANGE)}).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(10L), Long.valueOf(10L))).withTableName("dynamo_demo_app");
        helper.execute("dynamo_demo_app", (client, table) -> {
            try {
                client.createTable(request);
            }
            catch (AmazonServiceException e) {
                System.err.println("***********************************");
                System.err.println(e.getErrorMessage());
                System.err.println("***********************************");
            }
        });
    }

    public StringObjectMap addItemToTable() {
        IDynamoHelper helper = (IDynamoHelper)ApplicationContext.getInstance(IDynamoHelper.class);
        HashMap<String, Number> someAttribute = new HashMap<String, Number>();
        someAttribute.put("value", 5);
        someAttribute.put("score", 0.8);
        Put put = Put.builder("dynamo_demo_app").withKey("id", "d:user:" + UUID.randomUUID().toString(), "scope", "client").addAttribute("attr_1", someAttribute).addAttribute("attr_2", 1).build();
        helper.persist(put);
        StringObjectMap response = new StringObjectMap();
        response.put("id", put.getKeyValue(), "scope", put.getSortKeyValue());
        return response;
    }

    public ClientObject getItemFromTable(StringObjectMap response) {
        IDynamoHelper helper = (IDynamoHelper)ApplicationContext.getInstance(IDynamoHelper.class);
        return helper.fineOne(Get.builder("dynamo_demo_app").withKey("id", response.getString("id")).withSortKey("scope", response.getString("scope")).build(), new ICustomRowMapper(), ClientObject.class).orElse(null);
    }

    public static class ClientObject {
        private String userId;
        private String namespace;
        private Map<String, Object> attributes;

        public void addAttribute(String key, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
        }

        public String getUserId() {
            return this.userId;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientObject)) {
                return false;
            }
            ClientObject other = (ClientObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            Map<String, Object> this$attributes = this.getAttributes();
            Map<String, Object> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClientObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            Map<String, Object> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "DemoApplication.ClientObject(userId=" + this.getUserId() + ", namespace=" + this.getNamespace() + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
        }
    }

    public static class ICustomRowMapper
    implements IDynamoHelper.IRowMapper<ClientObject> {
        @Override
        public ClientObject map(Item item) {
            ClientObject co = new ClientObject();
            co.setUserId(item.getString("id"));
            co.setNamespace(item.getString("scope"));
            item.attributes().forEach(stringObjectEntry -> co.addAttribute((String)stringObjectEntry.getKey(), stringObjectEntry.getValue()));
            return co;
        }
    }
}

