/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.dynamo.operation;

import io.github.devlibx.easy.database.dynamo.operation.Attribute;
import java.util.ArrayList;
import java.util.List;

public class Put {
    private String table;
    private String keyName;
    private Object keyValue;
    private String sortKeyName;
    private Object sortKeyValue;
    private List<Attribute> attributes;

    public static Builder builder(String tableName) {
        return new Builder(tableName);
    }

    public String getTable() {
        return this.table;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public String getSortKeyName() {
        return this.sortKeyName;
    }

    public Object getSortKeyValue() {
        return this.sortKeyValue;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setKeyValue(Object keyValue) {
        this.keyValue = keyValue;
    }

    public void setSortKeyName(String sortKeyName) {
        this.sortKeyName = sortKeyName;
    }

    public void setSortKeyValue(Object sortKeyValue) {
        this.sortKeyValue = sortKeyValue;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Put)) {
            return false;
        }
        Put other = (Put)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$keyName = this.getKeyName();
        String other$keyName = other.getKeyName();
        if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
            return false;
        }
        Object this$keyValue = this.getKeyValue();
        Object other$keyValue = other.getKeyValue();
        if (this$keyValue == null ? other$keyValue != null : !this$keyValue.equals(other$keyValue)) {
            return false;
        }
        String this$sortKeyName = this.getSortKeyName();
        String other$sortKeyName = other.getSortKeyName();
        if (this$sortKeyName == null ? other$sortKeyName != null : !this$sortKeyName.equals(other$sortKeyName)) {
            return false;
        }
        Object this$sortKeyValue = this.getSortKeyValue();
        Object other$sortKeyValue = other.getSortKeyValue();
        if (this$sortKeyValue == null ? other$sortKeyValue != null : !this$sortKeyValue.equals(other$sortKeyValue)) {
            return false;
        }
        List<Attribute> this$attributes = this.getAttributes();
        List<Attribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Put;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $keyName = this.getKeyName();
        result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
        Object $keyValue = this.getKeyValue();
        result = result * 59 + ($keyValue == null ? 43 : $keyValue.hashCode());
        String $sortKeyName = this.getSortKeyName();
        result = result * 59 + ($sortKeyName == null ? 43 : $sortKeyName.hashCode());
        Object $sortKeyValue = this.getSortKeyValue();
        result = result * 59 + ($sortKeyValue == null ? 43 : $sortKeyValue.hashCode());
        List<Attribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "Put(table=" + this.getTable() + ", keyName=" + this.getKeyName() + ", keyValue=" + String.valueOf(this.getKeyValue()) + ", sortKeyName=" + this.getSortKeyName() + ", sortKeyValue=" + String.valueOf(this.getSortKeyValue()) + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    public Put() {
    }

    public Put(String table, String keyName, Object keyValue, String sortKeyName, Object sortKeyValue, List<Attribute> attributes) {
        this.table = table;
        this.keyName = keyName;
        this.keyValue = keyValue;
        this.sortKeyName = sortKeyName;
        this.sortKeyValue = sortKeyValue;
        this.attributes = attributes;
    }

    public static class Builder {
        private final String table;
        private String keyName;
        private Object keyValue;
        private String sortKeyName;
        private Object sortKeyValue;
        private List<Attribute> attributes;

        public Builder(String table) {
            this.table = table;
        }

        public Builder withKey(String keyName, Object keyValue) {
            this.keyName = keyName;
            this.keyValue = keyValue;
            return this;
        }

        public Builder withSortKey(String sortKeyName, Object sortKeyValue) {
            this.sortKeyName = sortKeyName;
            this.sortKeyValue = sortKeyValue;
            return this;
        }

        public Builder withKey(String keyName, Object keyValue, String sortKeyName, Object sortKeyValue) {
            this.keyName = keyName;
            this.keyValue = keyValue;
            this.sortKeyName = sortKeyName;
            this.sortKeyValue = sortKeyValue;
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<Attribute>();
            }
            this.attributes.add(new Attribute(name, value));
            return this;
        }

        public Put build() {
            Put obj = new Put();
            obj.table = this.table;
            obj.keyName = this.keyName;
            obj.keyValue = this.keyValue;
            obj.sortKeyName = this.sortKeyName;
            obj.sortKeyValue = this.sortKeyValue;
            if (this.attributes != null) {
                obj.attributes = new ArrayList<Attribute>();
                obj.attributes.addAll(this.attributes);
            }
            return obj;
        }
    }

    public static class PutBuilder {
        private String table;
        private String keyName;
        private Object keyValue;
        private String sortKeyName;
        private Object sortKeyValue;
        private List<Attribute> attributes;

        PutBuilder() {
        }

        public PutBuilder table(String table) {
            this.table = table;
            return this;
        }

        public PutBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public PutBuilder keyValue(Object keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public PutBuilder sortKeyName(String sortKeyName) {
            this.sortKeyName = sortKeyName;
            return this;
        }

        public PutBuilder sortKeyValue(Object sortKeyValue) {
            this.sortKeyValue = sortKeyValue;
            return this;
        }

        public PutBuilder attributes(List<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Put build() {
            return new Put(this.table, this.keyName, this.keyValue, this.sortKeyName, this.sortKeyValue, this.attributes);
        }

        public String toString() {
            return "Put.PutBuilder(table=" + this.table + ", keyName=" + this.keyName + ", keyValue=" + String.valueOf(this.keyValue) + ", sortKeyName=" + this.sortKeyName + ", sortKeyValue=" + String.valueOf(this.sortKeyValue) + ", attributes=" + String.valueOf(this.attributes) + ")";
        }
    }
}

