/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.dynamic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.collection.CollectionHelper;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.DefaultGeneratorStrategy;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import net.sf.cglib.transform.impl.AddPropertyTransformer;
import org.apache.commons.beanutils.PropertyUtils;
import org.objectweb.asm.Type;

public class MapToObjectHelper {
    private Map<Set<String>, Enhancer> classCache = new HashMap<Set<String>, Enhancer>();

    public static void main(String[] args) throws Exception {
        MapToObjectHelper e1 = new MapToObjectHelper();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("t", 21);
        StringObjectMap input = new StringObjectMap();
        input.put("rain", true);
        for (int j = 0; j < 100; ++j) {
            input.put("rain_" + j, true);
        }
        input.put("fail", 10);
        input.put("e", e1);
        input.put("map", map);
        input.put("list", Arrays.asList(17, 11));
        MapToObjectHelper helper = new MapToObjectHelper();
        Object output = helper.generateDynamicClassFromMap((Map<String, Object>)input);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            output = helper.generateDynamicClassFromMap((Map<String, Object>)input);
        }
        System.out.println("Time=" + (System.currentTimeMillis() - start));
        ObjectMapper om = new ObjectMapper();
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public Object generateDynamicClassFromMap(Map<String, Object> object) throws Exception {
        TreeSet<String> properties = new TreeSet<String>();
        this.populateProperties(object, properties);
        this.setupClasses(object, properties);
        Enhancer e = this.classCache.get(properties);
        Object parentObject = e.create();
        for (String key : object.keySet()) {
            if (Strings.isNullOrEmpty((String)key) || object.get(key) == null) continue;
            if (object.get(key) instanceof Map) {
                Object child = this.generateDynamicClassFromMap((Map)object.get(key));
                PropertyUtils.setSimpleProperty((Object)parentObject, (String)key, (Object)child);
                continue;
            }
            if (object.get(key) instanceof List) {
                PropertyUtils.setSimpleProperty((Object)parentObject, (String)key, (Object)CollectionHelper.convertListToObjectArray((Object)object.get(key)));
                continue;
            }
            PropertyUtils.setSimpleProperty((Object)parentObject, (String)key, (Object)object.get(key));
        }
        return parentObject;
    }

    private void setupClasses(final Map<String, Object> object, Set<String> properties) {
        if (properties.isEmpty()) {
            this.populateProperties(object, properties);
        }
        if (!this.classCache.containsKey(properties)) {
            Enhancer e = new Enhancer();
            e.setSerialVersionUID(Long.valueOf(System.currentTimeMillis() + (long)new Random().nextInt()));
            e.setCallback((Callback)NoOp.INSTANCE);
            e.setStrategy((GeneratorStrategy)new DefaultGeneratorStrategy(){

                protected ClassGenerator transform(ClassGenerator cg) {
                    return new TransformingClassGenerator(cg, (ClassTransformer)MapToObjectHelper.this.generateAddPropertyTransformer(object));
                }
            });
            this.classCache.put(properties, e);
        }
        for (String prop : properties) {
            if (!(object.get(prop) instanceof Map)) continue;
            this.setupClasses((Map)object.get(prop), new TreeSet<String>());
        }
    }

    private void populateProperties(Map<String, Object> object, Set<String> properties) {
        properties.addAll(object.keySet());
    }

    public <T> T convertMapToDynamicClass(Class<T> cls, final Map<String, Object> object) throws Exception {
        Enhancer e = new Enhancer();
        e.setSuperclass(cls);
        e.setCallback((Callback)NoOp.INSTANCE);
        e.setStrategy((GeneratorStrategy)new DefaultGeneratorStrategy(){

            protected ClassGenerator transform(ClassGenerator cg) {
                return new TransformingClassGenerator(cg, (ClassTransformer)MapToObjectHelper.this.generateAddPropertyTransformer(object));
            }
        });
        Object obj = e.create();
        for (String key : object.keySet()) {
            if (Strings.isNullOrEmpty((String)key) || object.get(key) == null) continue;
            if (object.get(key) instanceof List) {
                PropertyUtils.setSimpleProperty((Object)obj, (String)key, (Object)CollectionHelper.convertListToObjectArray((Object)object.get(key)));
                continue;
            }
            PropertyUtils.setSimpleProperty((Object)obj, (String)key, (Object)object.get(key));
        }
        return (T)obj;
    }

    private AddPropertyTransformer generateAddPropertyTransformer(Map<String, Object> object) {
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        for (String key : object.keySet()) {
            if (Strings.isNullOrEmpty((String)key) || object.get(key) == null) continue;
            properties.add(key);
            if (object.get(key) instanceof List) {
                types.add(Type.getType(Object[].class));
                continue;
            }
            if (object.get(key) instanceof Map) {
                types.add(Type.getType(Object.class));
                continue;
            }
            types.add(Type.getType(object.get(key).getClass()));
        }
        String[] keys = new String[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            keys[i] = (String)properties.get(i);
        }
        Type[] _types = new Type[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            _types[i] = (Type)types.get(i);
        }
        return new AddPropertyTransformer(keys, _types);
    }
}

