/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.sync;

import io.github.devlibx.easy.http.ResponseObject;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Server;
import io.github.devlibx.easy.http.exception.EasyHttpExceptions;
import io.github.devlibx.easy.http.sync.IHttpResponseProcessor;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpResponseProcessor
implements IHttpResponseProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpResponseProcessor.class);

    @Override
    public ResponseObject process(Server server, Api api, CloseableHttpResponse response) {
        int statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (response == null) {
            return ResponseObject.builder().statusCode(statusCode).build();
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (api.getAcceptableCodes() == null || api.getAcceptableCodes().isEmpty()) {
            api.setAcceptableCodes(Api.DEFAULT_ACCEPTABLE_CODES);
        }
        byte[] body = null;
        if (api.getAcceptableCodes().contains(statusCode)) {
            try {
                body = response.getEntity() != null ? EntityUtils.toByteArray((HttpEntity)response.getEntity()) : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ResponseObject.builder().success(true).body(body).statusCode(statusCode).build();
        }
        try {
            body = response.getEntity() != null ? EntityUtils.toByteArray((HttpEntity)response.getEntity()) : null;
            return ResponseObject.builder().body(body).statusCode(statusCode).build();
        }
        catch (Exception ignored) {
            return ResponseObject.builder().statusCode(statusCode).build();
        }
    }

    @Override
    public ResponseObject processException(Server server, Api api, Throwable e) {
        return ResponseObject.builder().exception(e).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).build();
    }

    @Override
    public void processResponseForException(ResponseObject response) {
        if (response.isSuccess()) {
            return;
        }
        throw EasyHttpExceptions.convert(response.getStatusCode(), response.getException(), response);
    }
}

