/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.jacoco.filter;

import io.github.devopsplugin.git.vo.DiffEntryWrapper;
import io.github.devopsplugin.jacoco.util.CollectionUtil;
import io.github.devopsplugin.jacoco.util.FilterUtil;
import io.github.devopsplugin.jacoco.util.LineNumberNodeWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.diff.Edit;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class DiffFilter
implements IFilter {
    private static final String SOURCE_PATH_PREFIX = "/src/main/java/";
    private final Map<String, DiffEntryWrapper> classPathDiffEntryMap = new HashMap<String, DiffEntryWrapper>();

    public DiffFilter(MavenProject project, List<DiffEntryWrapper> entries) {
        File baseDir = project.getBasedir();
        String baseDirPath = baseDir.getAbsolutePath();
        List modules = project.getModules();
        for (DiffEntryWrapper entry : entries) {
            if (!entry.getAbsoluteNewPath().startsWith(baseDirPath)) continue;
            String name = StringUtils.replaceOnce((String)entry.getAbsoluteNewPath(), (String)baseDirPath, (String)"");
            if (CollectionUtil.isNotEmpty(modules)) {
                for (String module : modules) {
                    if (!name.startsWith("/" + module)) continue;
                    name = StringUtils.replaceOnce((String)name, (String)("/" + module), (String)"");
                    break;
                }
            }
            if (!name.startsWith(SOURCE_PATH_PREFIX)) continue;
            name = StringUtils.replaceOnce((String)name, (String)SOURCE_PATH_PREFIX, (String)"");
            this.classPathDiffEntryMap.put(name, entry);
        }
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        String classPath = FilterUtil.getClassPath(context);
        InsnList instructions = methodNode.instructions;
        DiffEntryWrapper wrapper = this.classPathDiffEntryMap.get(classPath);
        if (wrapper == null) {
            output.ignore(instructions.getFirst(), instructions.getLast());
            return;
        }
        List<LineNumberNodeWrapper> nodeWrappers = FilterUtil.collectLineNumberNodeList(instructions);
        for (Edit edit : wrapper.getEdits()) {
            if (edit.getType() != Edit.Type.INSERT && edit.getType() != Edit.Type.REPLACE) continue;
            for (LineNumberNodeWrapper nodeWrapper : nodeWrappers) {
                int line = nodeWrapper.getLine();
                if (line <= edit.getBeginB() || line > edit.getEndB()) continue;
                nodeWrapper.setIgnored(false);
            }
        }
        for (LineNumberNodeWrapper nodeWrapper : nodeWrappers) {
            if (!nodeWrapper.isIgnored()) continue;
            output.ignore((AbstractInsnNode)nodeWrapper.getNode(), nodeWrapper.getNext());
        }
    }
}

