/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.jacoco.filter;

import io.github.devopsplugin.jacoco.util.CollectionUtil;
import io.github.devopsplugin.jacoco.util.FilterUtil;
import io.github.devopsplugin.jacoco.util.LineNumberNodeWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.lib.PersonIdent;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class PersonFilter
implements IFilter {
    private static final String SOURCE_PATH_PREFIX = "src/main/java/";
    private final Map<String, BlameResult> classPathBlameResultMap = new HashMap<String, BlameResult>();
    private final PersonInfo personInfo;

    public PersonFilter(MavenProject project, PersonInfo personInfo, List<BlameResult> blameResults) {
        List modules = project.getModules();
        if (project.getParent() != null && CollectionUtil.isNotEmpty(project.getParent().getModules())) {
            modules.addAll(project.getParent().getModules());
        }
        for (BlameResult blameResult : blameResults) {
            String name = blameResult.getResultPath();
            if (CollectionUtil.isNotEmpty(modules)) {
                for (String module : modules) {
                    if (!name.startsWith(module)) continue;
                    name = StringUtils.replaceOnce((String)name, (String)module, (String)"");
                    break;
                }
            }
            if (!name.startsWith(SOURCE_PATH_PREFIX)) continue;
            name = StringUtils.replaceOnce((String)name, (String)SOURCE_PATH_PREFIX, (String)"");
            this.classPathBlameResultMap.put(name, blameResult);
        }
        this.personInfo = personInfo;
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (this.personInfo == null) {
            return;
        }
        String classPath = FilterUtil.getClassPath(context);
        InsnList instructions = methodNode.instructions;
        BlameResult blameResult = this.classPathBlameResultMap.get(classPath);
        if (blameResult == null) {
            output.ignore(instructions.getFirst(), instructions.getLast());
            return;
        }
        List<LineNumberNodeWrapper> nodeWrappers = FilterUtil.collectLineNumberNodeList(instructions);
        for (LineNumberNodeWrapper nodeWrapper : nodeWrappers) {
            int line = nodeWrapper.getLine() - 1;
            PersonIdent personIdent = this.personInfo.getType().getPerson(blameResult, line);
            if (!this.personInfo.accept(personIdent)) continue;
            nodeWrapper.setIgnored(false);
        }
        for (LineNumberNodeWrapper nodeWrapper : nodeWrappers) {
            if (!nodeWrapper.isIgnored()) continue;
            output.ignore((AbstractInsnNode)nodeWrapper.getNode(), nodeWrapper.getNext());
        }
    }

    public static enum PersonType {
        AUTHOR{

            @Override
            public PersonIdent getPerson(BlameResult blameResult, int line) {
                return blameResult.getSourceAuthor(line);
            }
        };


        public abstract PersonIdent getPerson(BlameResult var1, int var2);
    }

    public static class PersonInfo {
        private String name;
        private String email;
        private PersonType type;

        public PersonInfo(String name, String email, PersonType type) {
            this.name = name;
            this.email = email;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public PersonType getType() {
            return this.type;
        }

        public boolean accept(PersonIdent personIdent) {
            if (personIdent == null) {
                return false;
            }
            if (StringUtils.isNotBlank((String)this.name) && !StringUtils.equals((String)this.name, (String)personIdent.getName())) {
                return false;
            }
            return !StringUtils.isNotBlank((String)this.email) || StringUtils.equals((String)this.email, (String)personIdent.getEmailAddress());
        }
    }
}

