/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.jacoco.maven;

import io.github.devopsplugin.git.helper.BlameHelper;
import io.github.devopsplugin.git.helper.DiffHelper;
import io.github.devopsplugin.git.vo.DiffEntryWrapper;
import io.github.devopsplugin.jacoco.filter.DiffFilter;
import io.github.devopsplugin.jacoco.filter.PersonFilter;
import io.github.devopsplugin.jacoco.util.CollectionUtil;
import io.github.devopsplugin.jacoco.util.FilterUtil;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jacoco.maven.AgentMojo;

@Mojo(name="prepare-agent", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DiffAgentMojo
extends AgentMojo {
    private static final AtomicBoolean LOCK = new AtomicBoolean(false);
    private static final String GIT_REGEX = "\\.git$";
    @Parameter(property="jacoco.git.oldrev", defaultValue="")
    private String oldRev;
    @Parameter(property="jacoco.git.newrev", defaultValue="")
    private String newRev;
    @Parameter(property="jacoco.author.name", defaultValue="")
    private String authorName;
    @Parameter(property="jacoco.author.email", defaultValue="")
    private String authorEmail;

    public void executeMojo() {
        try {
            if (StringUtils.isNotBlank((String)this.oldRev) && StringUtils.isNotBlank((String)this.newRev)) {
                this.getLog().info((CharSequence)("start execute diff filter for old rev [" + this.oldRev + "] and new rev [" + this.newRev + "]"));
                this.doDiffFilter();
                this.getLog().info((CharSequence)("finished execute diff filter for old rev [" + this.oldRev + "] and new rev [" + this.newRev + "]"));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("failed to execute diff filter for old rev [" + this.oldRev + "] and new rev [" + this.newRev + "]"));
        }
        super.executeMojo();
    }

    private void doDiffFilter() throws Exception {
        if (LOCK.getAndSet(true)) {
            return;
        }
        File baseDir = this.getProject().getBasedir();
        File gitDir = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(baseDir)).getGitDir();
        List<DiffEntryWrapper> diffEntries = DiffHelper.calculateDiff((File)(gitDir = new File(gitDir.getAbsolutePath().replaceAll(GIT_REGEX, ""))), (String)this.oldRev, (String)this.newRev, (boolean)false).stream().filter(diffEntry -> !diffEntry.isDeleted()).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(diffEntries)) {
            return;
        }
        DiffFilter diffFilter = new DiffFilter(this.getProject(), diffEntries);
        FilterUtil.appendFilter(diffFilter);
        if (StringUtils.isNotBlank((String)this.authorName) || StringUtils.isNotBlank((String)this.authorEmail)) {
            Set filePaths = diffEntries.stream().map(DiffEntryWrapper::getNewPath).collect(Collectors.toSet());
            List blameResults = BlameHelper.getBlames((File)gitDir, filePaths, (String)this.newRev);
            PersonFilter.PersonInfo author = new PersonFilter.PersonInfo(this.authorName, this.authorEmail, PersonFilter.PersonType.AUTHOR);
            PersonFilter authorFilter = new PersonFilter(this.getProject(), author, blameResults);
            FilterUtil.appendFilter(authorFilter);
        }
    }
}

