/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.auth;

import com.auth0.spring.security.api.JwtWebSecurityConfigurer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
public class AuthenticationConfig
extends WebSecurityConfigurerAdapter {
    public static final String API_PATTERN_PUBLIC = "/api/public";
    public static final String API_PATTERN_AUTHORIZED = "/api/authorized";
    public static final String API_PATTERN_INTERNAL = "/api/internal";
    public static final String API_PATTERN_ROOT = "/api/root";
    public static final List<String> ALLOWED_METHODS = Arrays.asList("GET", "POST", "PUT", "DELETE");
    public static final String AUTH0_API_SCOPE_INTERNAL = "internal";
    public static final String AUTH0_API_SCOPE_ROOT = "root";
    @Value(value="${inmanlabs.auth0.apiAudience}")
    private String apiAudience;
    @Value(value="${inmanlabs.auth0.issuer}")
    private String issuer;
    @Value(value="${inmanlabs.client.requestOrigin}")
    private String requestOrigin;

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Collections.singletonList(this.requestOrigin));
        configuration.setAllowedMethods(ALLOWED_METHODS);
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.addAllowedHeader("Authorization");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.cors();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)JwtWebSecurityConfigurer.forRS256((String)this.apiAudience, (String)this.issuer).configure(http).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/api/public/*"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/authorized/*"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/api/internal/*"})).hasAuthority(AUTH0_API_SCOPE_INTERNAL).antMatchers(HttpMethod.GET, new String[]{"/api/root/*"})).hasAuthority(AUTH0_API_SCOPE_ROOT);
    }
}

