/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.client;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.inmanlabs.commons.jackson.InstantDeserializer;
import com.inmanlabs.commons.jackson.InstantSerializer;
import com.inmanlabs.commons.jackson.LocalDateTimeDeserializer;
import com.inmanlabs.commons.jackson.LocalDateTimeSerializer;
import com.inmanlabs.commons.rest.LoggingRequestInterceptor;
import com.inmanlabs.commons.rest.LoggingResponseErrorHandler;
import com.inmanlabs.commons.web.error.ExternalApiException;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Service
public class RestClient {
    private static Logger logger = LoggerFactory.getLogger(RestClient.class);
    private RestTemplate rest = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));

    public RestClient(@Value(value="${inmanlabs.restclient.logging}") boolean logCalls) {
        if (logCalls) {
            ArrayList<LoggingRequestInterceptor> interceptors = new ArrayList<LoggingRequestInterceptor>();
            interceptors.add(new LoggingRequestInterceptor());
            this.rest.setInterceptors(interceptors);
        }
        this.rest.setErrorHandler((ResponseErrorHandler)new LoggingResponseErrorHandler());
        MappingJackson2HttpMessageConverter messageConverter = this.rest.getMessageConverters().stream().filter(MappingJackson2HttpMessageConverter.class::isInstance).map(MappingJackson2HttpMessageConverter.class::cast).findFirst().orElseThrow(() -> new RuntimeException("MappingJackson2HttpMessageConverter not found"));
        SimpleModule module = new SimpleModule();
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer());
        messageConverter.getObjectMapper().registerModule((Module)module);
        messageConverter.getObjectMapper().configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
    }

    public <U, V> V send(HttpMethod method, HttpEntity<U> requestEntity, String url, ParameterizedTypeReference<V> responseType) throws FailedDependencyException {
        ResponseEntity responseEntity;
        try {
            logger.debug(String.format("Making %s call to %s", method, url));
            responseEntity = this.rest.exchange(url, method, requestEntity, responseType, new Object[0]);
        }
        catch (ExternalApiException e) {
            logger.error(String.format("%s on %s returned in error: %s", method, url, e.getMessage()), (Throwable)e);
            throw new FailedDependencyException("An error occurred while connecting to a third party API", e);
        }
        catch (Exception e) {
            logger.error(String.format("%s on %s returned an uncategorized error: %s", method, url, e.getMessage()), (Throwable)e);
            throw new FailedDependencyException("An uncategorized error occurred while connecting to a third party API", e);
        }
        return (V)responseEntity.getBody();
    }
}

