/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.location;

import com.google.maps.GeoApiContext;
import com.google.maps.PlacesApi;
import com.google.maps.errors.ApiException;
import com.google.maps.model.AutocompletePrediction;
import com.google.maps.model.PlaceDetails;
import com.inmanlabs.commons.google.GooglePlacesConfig;
import com.inmanlabs.commons.location.Location;
import com.inmanlabs.commons.location.LocationUtils;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import com.inmanlabs.commons.web.error.NotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LocationService {
    private Logger logger = LoggerFactory.getLogger(LocationService.class);
    @Resource
    private GooglePlacesConfig googlePlacesConfig;

    public List<AutocompletePrediction> searchForGooglePlace(String searchString) throws FailedDependencyException {
        try {
            AutocompletePrediction[] predictions = (AutocompletePrediction[])PlacesApi.queryAutocomplete((GeoApiContext)this.googlePlacesConfig.getClient(), (String)searchString).await();
            return Arrays.asList(predictions);
        }
        catch (ApiException | IOException | InterruptedException e) {
            this.logger.error("Error while accessing Google Places API", e);
            throw new FailedDependencyException("Something went wrong while accessing Google API: " + e.getMessage());
        }
    }

    public Location fetchGooglePlaceAndConvertToLocation(String googlePlaceId) throws NotFoundException {
        if (StringUtils.isBlank((CharSequence)googlePlaceId)) {
            throw new NotFoundException("Cannot fetch Google Place without a googlePlaceId");
        }
        try {
            this.logger.info(String.format("Fetching Google Place %s from Google API...", googlePlaceId));
            PlaceDetails googlePlace = (PlaceDetails)PlacesApi.placeDetails((GeoApiContext)this.googlePlacesConfig.getClient(), (String)googlePlaceId).await();
            return LocationUtils.mapPlaceToLocation(googlePlace);
        }
        catch (ApiException | IOException | InterruptedException e) {
            this.logger.error("Error while accessing Google Places API", e);
            throw new NotFoundException("Could not find Google Place with id: " + googlePlaceId);
        }
    }
}

