/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.location.coordinate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inmanlabs.commons.location.coordinate.CoordinateUtils;
import java.text.DecimalFormat;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class Coordinate
implements Comparable<Coordinate> {
    private Float latitude;
    private Float longitude;
    @JsonIgnore
    @Transient
    private DecimalFormat format;

    public Coordinate() {
    }

    public Coordinate(Float latitude, Float longitude) {
        if (!CoordinateUtils.isValidLatitude(latitude.floatValue()) || !CoordinateUtils.isValidLongitude(longitude.floatValue())) {
            throw new IllegalArgumentException("The parameters did not pass validation as defined by the CoordinateUtils class");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.format = new DecimalFormat("##.######");
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setLatitude(Float latitude) {
        if (!CoordinateUtils.isValidLatitude(latitude.floatValue())) {
            throw new IllegalArgumentException("The parameter did not pass validation as defined by the CoordinateUtils class");
        }
        this.latitude = latitude;
    }

    public void setLongitude(Float longitude) {
        if (!CoordinateUtils.isValidLongitude(longitude.floatValue())) {
            throw new IllegalArgumentException("The parameter did not pass validation as defined by the CoordinateUtils class");
        }
        this.longitude = longitude;
    }

    @JsonIgnore
    @Transient
    public String getLatitudeAsString() {
        return this.format.format(this.latitude);
    }

    @JsonIgnore
    @Transient
    public String getLongitudeAsString() {
        return this.format.format(this.longitude);
    }

    public String toString() {
        return this.format.format(this.latitude) + ", " + this.format.format(this.longitude);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Coordinate)) {
            return false;
        }
        Coordinate c = (Coordinate)o;
        String me = this.getLatitudeAsString() + this.getLongitudeAsString();
        String you = c.getLatitudeAsString() + c.getLongitudeAsString();
        return me.equals(you);
    }

    public int hashCode() {
        String me = this.getLatitudeAsString() + this.getLongitudeAsString();
        return 31 * me.hashCode();
    }

    @Override
    public int compareTo(Coordinate c) {
        Double youDbl;
        String me = this.getLatitudeAsString() + this.getLongitudeAsString();
        String you = c.getLatitudeAsString() + c.getLongitudeAsString();
        Double meDbl = Double.valueOf(me);
        if (meDbl == (youDbl = Double.valueOf(you))) {
            return 0;
        }
        Double tmp = Math.floor(meDbl - youDbl);
        return tmp.intValue();
    }
}

