/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.location.coordinate;

import com.inmanlabs.commons.location.coordinate.Coordinate;
import java.util.HashMap;

class CoordinateUtils {
    public static float MIN_LATITUDE = Float.valueOf("-90.0000").floatValue();
    public static float MAX_LATITUDE = Float.valueOf("90.0000").floatValue();
    public static float MIN_LONGITUDE = Float.valueOf("-180.0000").floatValue();
    public static float MAX_LONGITUDE = Float.valueOf("180.0000").floatValue();
    public static float EARTH_DIAMETER = Float.valueOf("12756.274").floatValue();

    CoordinateUtils() {
    }

    public static boolean isValidLatitude(float latitude) {
        return latitude >= MIN_LATITUDE && latitude <= MAX_LATITUDE;
    }

    public static boolean isValidLongitude(float longitude) {
        return longitude >= MIN_LONGITUDE && longitude <= MAX_LONGITUDE;
    }

    public static double latitudeConstant() {
        return (double)EARTH_DIAMETER * (Math.PI / (double)Float.valueOf("360").floatValue());
    }

    public static double longitudeConstant(float latitude) {
        return (double)EARTH_DIAMETER * Math.PI * Math.abs(Math.cos(Math.abs(latitude))) / (double)Float.valueOf("360").floatValue();
    }

    public static Coordinate addDistanceNorth(float latitude, float longitude, int distance) {
        if (!CoordinateUtils.isValidLatitude(latitude) || !CoordinateUtils.isValidLongitude(longitude) || distance <= 0) {
            throw new IllegalArgumentException("All parameters are required and must be valid");
        }
        float kilometers = (float)distance / 1000.0f;
        double newLat = (double)latitude + (double)kilometers / CoordinateUtils.latitudeConstant();
        return new Coordinate(Float.valueOf((float)newLat), Float.valueOf(longitude));
    }

    public static Coordinate addDistanceSouth(float latitude, float longitude, int distance) {
        if (!CoordinateUtils.isValidLatitude(latitude) || !CoordinateUtils.isValidLongitude(longitude) || distance <= 0) {
            throw new IllegalArgumentException("All parameters are required and must be valid");
        }
        float kilometers = (float)distance / 1000.0f;
        double newLat = (double)latitude - (double)kilometers / CoordinateUtils.latitudeConstant();
        return new Coordinate(Float.valueOf((float)newLat), Float.valueOf(longitude));
    }

    public static Coordinate addDistanceEast(float latitude, float longitude, int distance) {
        if (!CoordinateUtils.isValidLatitude(latitude) || !CoordinateUtils.isValidLongitude(longitude) || distance <= 0) {
            throw new IllegalArgumentException("All parameters are required and must be valid");
        }
        float kilometers = distance / 1000;
        double newLng = (double)longitude + (double)distance / CoordinateUtils.longitudeConstant(latitude);
        return new Coordinate(Float.valueOf(latitude), Float.valueOf((float)newLng));
    }

    public static Coordinate addDistanceWest(float latitude, float longitude, int distance) {
        if (!CoordinateUtils.isValidLatitude(latitude) || !CoordinateUtils.isValidLongitude(longitude) || distance <= 0) {
            throw new IllegalArgumentException("All parameters are required and must be valid");
        }
        float kilometers = distance / 1000;
        double newLng = (double)longitude - (double)distance / CoordinateUtils.longitudeConstant(latitude);
        return new Coordinate(Float.valueOf(latitude), Float.valueOf((float)newLng));
    }

    public static HashMap<String, Coordinate> getBoundingBox(float latitude, float longitude, int distance) {
        if (!CoordinateUtils.isValidLatitude(latitude) || !CoordinateUtils.isValidLongitude(longitude) || distance <= 0) {
            throw new IllegalArgumentException("All parameters are required and must be valid");
        }
        float kilometers = distance / 1000;
        HashMap<String, Coordinate> boundingBox = new HashMap<String, Coordinate>();
        Coordinate north = CoordinateUtils.addDistanceNorth(latitude, longitude, distance);
        Coordinate south = CoordinateUtils.addDistanceSouth(latitude, longitude, distance);
        Coordinate east = CoordinateUtils.addDistanceEast(latitude, longitude, distance);
        Coordinate west = CoordinateUtils.addDistanceWest(latitude, longitude, distance);
        boundingBox.put("NE", new Coordinate(north.getLatitude(), east.getLongitude()));
        boundingBox.put("SE", new Coordinate(south.getLatitude(), east.getLongitude()));
        boundingBox.put("SW", new Coordinate(south.getLatitude(), west.getLongitude()));
        boundingBox.put("NW", new Coordinate(north.getLatitude(), west.getLongitude()));
        return boundingBox;
    }
}

