/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.onfleet;

import com.inmanlabs.commons.client.RestClient;
import com.inmanlabs.commons.onfleet.BatchTasksRequest;
import com.inmanlabs.commons.onfleet.OnfleetAuthTestResponse;
import com.inmanlabs.commons.onfleet.OnfleetConfig;
import com.inmanlabs.commons.onfleet.model.OnfleetDestination;
import com.inmanlabs.commons.onfleet.model.OnfleetOrganization;
import com.inmanlabs.commons.onfleet.model.OnfleetRecipient;
import com.inmanlabs.commons.onfleet.model.OnfleetTask;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class OnfleetClient {
    private static Logger logger = LoggerFactory.getLogger(OnfleetClient.class);
    private static String host = "https://onfleet.com/api/v2";
    @Resource
    private OnfleetConfig config;
    @Resource
    private RestClient restClient;

    public OnfleetDestination createDestination(OnfleetDestination destination) throws FailedDependencyException {
        HttpMethod method = HttpMethod.POST;
        HttpEntity requestEntity = new HttpEntity((Object)destination, (MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = host + "/destinations";
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<OnfleetDestination>(){});
    }

    public OnfleetDestination getDestination(String id) throws FailedDependencyException {
        HttpMethod method = HttpMethod.GET;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = host + "/destinations/" + id;
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<OnfleetDestination>(){});
    }

    public OnfleetOrganization getMyOrganization() throws FailedDependencyException {
        HttpMethod method = HttpMethod.GET;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = host + "/organization";
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<OnfleetOrganization>(){});
    }

    public OnfleetRecipient createRecipient(OnfleetRecipient recipient) throws FailedDependencyException {
        HttpMethod method = HttpMethod.POST;
        HttpEntity requestEntity = new HttpEntity((Object)recipient, (MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = host + "/recipients";
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<OnfleetRecipient>(){});
    }

    public OnfleetRecipient getRecipient(String id) throws FailedDependencyException {
        HttpMethod method = HttpMethod.GET;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = host + "/recipients/" + id;
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<OnfleetRecipient>(){});
    }

    public OnfleetTask createTask(@NonNull OnfleetTask task) throws FailedDependencyException {
        logger.debug("Sending POST to Onfleet API with task: " + task);
        HttpMethod method = HttpMethod.POST;
        HttpEntity requestEntity = new HttpEntity((Object)task, (MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = host + "/tasks";
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<OnfleetTask>(){});
    }

    public List<OnfleetTask> uploadTasksBatch(@NonNull List<OnfleetTask> tasks) throws FailedDependencyException {
        BatchTasksRequest batchTasksRequest = new BatchTasksRequest(tasks);
        HttpEntity requestEntity = new HttpEntity((Object)batchTasksRequest, (MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = OnfleetClient.formulateTasksBatchUrl();
        logger.info("Batch uploading " + tasks.size() + " tasks to OnFleet API at: " + url);
        List<OnfleetTask> onFleetResponse = this.restClient.send(HttpMethod.POST, requestEntity, url, new ParameterizedTypeReference<List<OnfleetTask>>(){});
        if (onFleetResponse == null) {
            return new ArrayList<OnfleetTask>();
        }
        return onFleetResponse;
    }

    public OnfleetAuthTestResponse testAuth() throws FailedDependencyException {
        HttpEntity requestEntity = new HttpEntity((Object)"", (MultiValueMap)OnfleetClient.formulateHeaders(this.config));
        String url = OnfleetClient.formulateTestUrl();
        logger.info("Hitting test endpoint: " + url);
        OnfleetAuthTestResponse onfleetResponse = this.restClient.send(HttpMethod.GET, requestEntity, url, new ParameterizedTypeReference<OnfleetAuthTestResponse>(){});
        return onfleetResponse;
    }

    private static String formulateTestUrl() {
        return host + "/auth/test";
    }

    private static String formulateTasksBatchUrl() {
        return host + "/tasks/batch";
    }

    private static HttpHeaders formulateHeaders(OnfleetConfig config) {
        String base64token = Base64.getEncoder().encodeToString((config.getApiKey() + ":").getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "*/*");
        headers.add("Authorization", "Basic " + base64token);
        return headers;
    }
}

