/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inmanlabs.commons.persistence.DoNotClear;
import com.inmanlabs.commons.persistence.EntityStatus;
import com.inmanlabs.commons.persistence.Identifiable;
import com.inmanlabs.commons.persistence.Timestamped;
import com.inmanlabs.commons.web.error.InternalServerErrorException;
import com.vladmihalcea.hibernate.type.json.JsonStringType;
import java.lang.reflect.Field;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.UpdateTimestamp;

@MappedSuperclass
@TypeDef(name="json", typeClass=JsonStringType.class)
public class EntityBase
implements Identifiable,
Timestamped {
    @Id
    @Column(columnDefinition="VARCHAR(36)", updatable=false, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="org.hibernate.id.UUIDGenerator")
    @DoNotClear
    private String id;
    @CreationTimestamp
    @Column(updatable=false, nullable=false)
    @DoNotClear
    private Instant createdTime;
    @UpdateTimestamp
    @Column(nullable=false)
    @DoNotClear
    private Instant lastModifiedTime;
    @Enumerated(value=EnumType.STRING)
    @DoNotClear
    private EntityStatus entityStatus = EntityStatus.ACTIVE;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public Instant getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Instant lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public EntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(EntityStatus entityStatus) {
        this.entityStatus = entityStatus;
    }

    @Transient
    @JsonIgnore
    public void clearAllFields() {
        Field[] fields;
        for (Field f : fields = this.getClass().getSuperclass().getDeclaredFields()) {
            if (f.isAnnotationPresent(DoNotClear.class)) continue;
            try {
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                f.set(this, null);
                f.setAccessible(accessible);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
                throw new InternalServerErrorException("Something went wrong while clearing fields in " + this, e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSuperclass().getSimpleName() + ":" + this.getId();
    }
}

