/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.textline;

import com.inmanlabs.commons.client.RestClient;
import com.inmanlabs.commons.textline.TextlineConfig;
import com.inmanlabs.commons.textline.model.TextlineAccessToken;
import com.inmanlabs.commons.textline.model.TextlineAuthRequest;
import com.inmanlabs.commons.textline.model.TextlineAuthResponse;
import com.inmanlabs.commons.textline.model.TextlineMessage;
import com.inmanlabs.commons.textline.model.TextlineMessageResponse;
import com.inmanlabs.commons.textline.model.TextlineUser;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class TextlineClient {
    public static String SMS_SERVICE_IDENTIFIER = "TEXTLINE";
    private static Logger logger = LoggerFactory.getLogger(TextlineClient.class);
    private static String host = "https://application.textline.com/";
    @Resource
    private TextlineConfig config;
    @Resource
    private RestClient restClient;

    public TextlineAccessToken fetchAccessToken() throws FailedDependencyException {
        HttpMethod method = HttpMethod.POST;
        HttpEntity requestEntity = new HttpEntity((Object)TextlineClient.formulateAuthRequest(this.config), (MultiValueMap)TextlineClient.formulateUnauthorizedHeaders());
        String url = host + "/auth/sign_in.json";
        TextlineAuthResponse authResponse = this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<TextlineAuthResponse>(){});
        logger.debug("Fetched access token from Textline for user: " + authResponse.user.email);
        return authResponse.access_token;
    }

    public TextlineMessageResponse sendMessageToPhoneNumber(TextlineMessage message) throws FailedDependencyException {
        TextlineAccessToken accessToken = this.fetchAccessToken();
        HttpMethod method = HttpMethod.POST;
        HttpEntity requestEntity = new HttpEntity((Object)message, (MultiValueMap)TextlineClient.formulateAuthorizedHeaders(accessToken));
        String url = host + "/api/conversations.json";
        return this.restClient.send(method, requestEntity, url, new ParameterizedTypeReference<TextlineMessageResponse>(){});
    }

    private static String formulateTestUrl() {
        return host + "/auth/test";
    }

    private static String formulateTasksBatchUrl() {
        return host + "/tasks/batch";
    }

    private static TextlineAuthRequest formulateAuthRequest(TextlineConfig config) {
        TextlineAuthRequest request = new TextlineAuthRequest();
        TextlineUser user = new TextlineUser();
        user.email = config.getEmail();
        user.password = config.getPassword();
        request.api_key = config.getApiKey();
        request.user = user;
        return request;
    }

    private static HttpHeaders formulateUnauthorizedHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "*/*");
        return headers;
    }

    private static HttpHeaders formulateAuthorizedHeaders(TextlineAccessToken accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "*/*");
        headers.add("X-TGP-ACCESS-TOKEN", accessToken.token);
        return headers;
    }
}

