/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.user;

import com.inmanlabs.commons.web.error.BadRequestException;
import java.security.SecureRandom;
import java.time.Instant;
import javax.persistence.Embeddable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Embeddable
public class Secret {
    public static int DEFAULT_EXPIRATION_IN_MINUTES = 10;
    private static int ENCODER_STRENGTH = 12;
    private String hash;
    private String salt;
    private Instant expiration;

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Instant expiration) {
        this.expiration = expiration;
    }

    public static Secret newSecret(String plainText, int expirationInMinutes) {
        Secret secret = new Secret();
        String salt = Secret.randomSalt();
        Instant expiration = Instant.now().plusSeconds(expirationInMinutes * 60);
        secret.setHash(Secret.hash(plainText, salt));
        secret.setSalt(salt);
        secret.setExpiration(expiration);
        return secret;
    }

    public static Secret newSecret(String plainText) throws BadRequestException {
        if (StringUtils.isBlank((CharSequence)plainText)) {
            throw new BadRequestException("Password cannot be empty");
        }
        return Secret.newSecret(plainText, DEFAULT_EXPIRATION_IN_MINUTES);
    }

    public static boolean isValid(String plainText, Secret secret) {
        return Secret.matches(plainText, secret) && !Secret.isExpired(secret);
    }

    static String randomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return Hex.encodeHexString((byte[])salt);
    }

    static boolean isExpired(Secret secret) {
        if (secret == null || secret.getExpiration() == null) {
            return true;
        }
        return secret.getExpiration().isBefore(Instant.now());
    }

    static boolean matches(String plaintext, Secret secret) {
        if (secret == null || StringUtils.isBlank((CharSequence)plaintext) || StringUtils.isBlank((CharSequence)secret.getHash()) || StringUtils.isBlank((CharSequence)secret.getSalt())) {
            return false;
        }
        String expected = secret.getHash();
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder(ENCODER_STRENGTH);
        String fullSecret = Secret.combinePlaintextAndSalt(plaintext, secret.getSalt());
        return encoder.matches((CharSequence)fullSecret, expected);
    }

    static String hash(String plaintext, String salt) {
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder(ENCODER_STRENGTH);
        String fullSecret = Secret.combinePlaintextAndSalt(plaintext, salt);
        return encoder.encode((CharSequence)fullSecret);
    }

    private static String combinePlaintextAndSalt(String plainText, String salt) {
        return plainText + ":" + salt;
    }
}

