/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.web.error;

import org.springframework.http.HttpStatus;

public class ExternalApiException
extends RuntimeException {
    private HttpStatus dependencyStatus;
    private String dependencyBody;

    private ExternalApiException(HttpStatus status, String body) {
        super(ExternalApiException.formulateMessage(status, body));
        this.dependencyStatus = status;
        this.dependencyBody = body;
    }

    public static ExternalApiException fromResponse(HttpStatus dependencyStatus, String dependencyBody) {
        return new ExternalApiException(dependencyStatus, dependencyBody);
    }

    public HttpStatus getDependencyStatus() {
        return this.dependencyStatus;
    }

    public String getDependencyMessage() {
        return this.dependencyBody;
    }

    private static String formulateMessage(HttpStatus status, String body) {
        return "\"" + status.value() + ", " + status.getReasonPhrase() + "\". Response from their server: " + body;
    }
}

