package com.inmanlabs.commons.user;

import org.springframework.data.repository.CrudRepository;

import javax.transaction.Transactional;
import java.util.Optional;

@Transactional
public interface UserRepository extends CrudRepository<LocalUser, String> {

    @Transactional
    Optional<LocalUser> findByEmail(String phone);

    @Transactional
    Optional<LocalUser> findByPhone(String phone);

    @Transactional
    Optional<LocalUser> findByAuthZeroId(String auth0Id);
}
