/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.airtable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.inmanlabs.commons.airtable.AirtableConfig;
import com.inmanlabs.commons.airtable.AirtableDeleteResponse;
import com.inmanlabs.commons.airtable.AirtableListResponse;
import com.inmanlabs.commons.airtable.AirtableQuery;
import com.inmanlabs.commons.airtable.AirtableRecord;
import com.inmanlabs.commons.airtable.AirtableRequestBody;
import com.inmanlabs.commons.client.RestClient;
import com.inmanlabs.commons.web.error.BadRequestException;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import com.inmanlabs.commons.web.error.InternalServerErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AirtableClient {
    private static Logger logger = LoggerFactory.getLogger(AirtableClient.class);
    private static String host = "https://api.airtable.com/v0";
    @Resource
    private AirtableConfig config;
    @Resource
    private RestClient restClient;
    @Resource
    private ObjectMapper objectMapper;

    public <T> List<AirtableRecord<T>> listAllWithPaging(AirtableQuery query, Class<T> clazz) throws FailedDependencyException, BadRequestException {
        AirtableListResponse<T> listResponse = this.list(query, clazz);
        if (CollectionUtils.isEmpty(listResponse.getRecords())) {
            return new ArrayList<AirtableRecord<T>>();
        }
        List<AirtableRecord<T>> storeForms = listResponse.getRecords();
        String offset = listResponse.getOffset();
        while (!StringUtils.isBlank((CharSequence)offset)) {
            query.setOffset(offset);
            AirtableListResponse<T> newResponse = this.list(query, clazz);
            storeForms.addAll(newResponse.getRecords());
            try {
                Thread.sleep(205L);
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted while trying to sleep.", (Throwable)e);
                throw new InternalServerErrorException("Internal service error");
            }
            offset = newResponse.getOffset();
        }
        return storeForms;
    }

    public <T> AirtableListResponse<T> list(AirtableQuery query, Class<T> clazz) throws FailedDependencyException, BadRequestException {
        String baseUrl;
        String url;
        HttpEntity requestEntity = new HttpEntity((Object)"", (MultiValueMap)AirtableClient.formulateHeaders(this.config));
        AirtableListResponse response = (AirtableListResponse)this.restClient.send(HttpMethod.GET, requestEntity, url = this.formulateUrl(query, baseUrl = AirtableClient.formulateBaseUrl(this.config)), new ParameterizedTypeReference<AirtableListResponse<T>>(){});
        if (response == null) {
            return AirtableListResponse.empty();
        }
        return this.castReturnedMapAsJavaObject(clazz, response);
    }

    public <T> AirtableRecord<T> create(String schema, T entity, Class<T> clazz) throws FailedDependencyException {
        String baseUrl;
        String url;
        AirtableRequestBody<T> body = new AirtableRequestBody<T>(entity);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)AirtableClient.formulateHeaders(this.config));
        AirtableRecord response = (AirtableRecord)this.restClient.send(HttpMethod.POST, requestEntity, url = this.formulateUrl(schema, baseUrl = AirtableClient.formulateBaseUrl(this.config)), new ParameterizedTypeReference<AirtableRecord<T>>(){});
        if (response == null) {
            return null;
        }
        Object fields = this.objectMapper.convertValue(response.getFields(), clazz);
        response.setFields(fields);
        return response;
    }

    public AirtableDeleteResponse delete(String schema, String id) throws FailedDependencyException {
        HttpEntity requestEntity = new HttpEntity((Object)"", (MultiValueMap)AirtableClient.formulateHeaders(this.config));
        String baseUrl = AirtableClient.formulateBaseUrl(this.config);
        String url = this.formulateDeleteUrl(schema, baseUrl, id);
        return this.restClient.send(HttpMethod.DELETE, requestEntity, url, new ParameterizedTypeReference<AirtableDeleteResponse>(){});
    }

    private <T> AirtableListResponse<T> castReturnedMapAsJavaObject(Class<T> clazz, AirtableListResponse<T> response) throws BadRequestException {
        try {
            for (AirtableRecord<Object> airtableRecord : response.getRecords()) {
                Object fields = this.objectMapper.convertValue(airtableRecord.getFields(), clazz);
                airtableRecord.setFields(fields);
            }
            return response;
        }
        catch (IllegalArgumentException e) {
            logger.error("There was an error trying to cast the Airtable returned fields to a java object.", (Throwable)e);
            throw new BadRequestException("The given data model does not match the Airtable model");
        }
    }

    private String formulateUrl(String schema, String baseUrl) {
        return baseUrl + "/" + schema;
    }

    private String formulateDeleteUrl(String schema, String baseUrl, String id) {
        return baseUrl + "/" + schema + "/" + id;
    }

    private String formulateUrl(AirtableQuery query, String baseUrl) throws BadRequestException {
        try {
            String baseUrlWithSchema = baseUrl + "/" + query.getSchema();
            UriComponentsBuilder ucb = UriComponentsBuilder.fromHttpUrl((String)baseUrlWithSchema);
            if (!CollectionUtils.isEmpty(query.getFields())) {
                ucb.queryParam("fields", new Object[]{this.objectMapper.writeValueAsString(query.getFields())});
            }
            if (!StringUtils.isBlank((CharSequence)query.getFilterByFormula())) {
                ucb.queryParam("filterByFormula", new Object[]{query.getFilterByFormula()});
            }
            if (!Objects.isNull(query.getMaxRecords())) {
                ucb.queryParam("maxRecords", new Object[]{query.getMaxRecords()});
            }
            if (!Objects.isNull(query.getPageSize())) {
                ucb.queryParam("pageSize", new Object[]{query.getPageSize()});
            }
            if (!CollectionUtils.isEmpty(query.getSort())) {
                ucb.queryParam("sort", new Object[]{this.objectMapper.writeValueAsString(query.getSort())});
            }
            if (!StringUtils.isBlank((CharSequence)query.getView())) {
                ucb.queryParam("view", new Object[]{query.getView()});
            }
            if (!StringUtils.isBlank((CharSequence)query.getCellFormat())) {
                ucb.queryParam("cellFormat", new Object[]{query.getCellFormat()});
            }
            if (!StringUtils.isBlank((CharSequence)query.getTimezone())) {
                ucb.queryParam("timezone", new Object[]{query.getTimezone()});
            }
            if (!StringUtils.isBlank((CharSequence)query.getUserLocale())) {
                ucb.queryParam("userLocale", new Object[]{query.getUserLocale()});
            }
            if (!StringUtils.isBlank((CharSequence)query.getOffset())) {
                ucb.queryParam("offset", new Object[]{query.getOffset()});
            }
            return ucb.toUriString();
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException("Could not build Airtable URL", e);
        }
    }

    private static String formulateBaseUrl(AirtableConfig config) {
        return host + "/" + config.getAccountId();
    }

    private static HttpHeaders formulateHeaders(AirtableConfig config) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "*/*");
        headers.add("Authorization", "Bearer " + config.getApiKey());
        return headers;
    }
}

