/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.auth0;

import com.auth0.client.auth.AuthAPI;
import com.auth0.client.mgmt.ManagementAPI;
import com.auth0.client.mgmt.filter.UserFilter;
import com.auth0.exception.Auth0Exception;
import com.auth0.json.auth.TokenHolder;
import com.auth0.json.mgmt.users.User;
import com.auth0.json.mgmt.users.UsersPage;
import com.auth0.net.AuthRequest;
import com.auth0.net.Request;
import com.inmanlabs.commons.auth0.Auth0Config;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Auth0Client {
    private static Logger logger = LoggerFactory.getLogger(Auth0Client.class);
    @Resource
    private Auth0Config auth0Config;
    private AuthAPI authApi;
    private TokenHolder cachedToken;

    @PostConstruct
    public void initializeAuth0() {
        this.authApi = new AuthAPI(this.auth0Config.getDomain(), this.auth0Config.getClientId(), this.auth0Config.getClientSecret());
    }

    public UsersPage list(UserFilter filter) throws FailedDependencyException {
        try {
            ManagementAPI api = this.mgmtApi();
            Request request = api.users().list(filter);
            return (UsersPage)request.execute();
        }
        catch (Auth0Exception e) {
            logger.error("Error while calling Auth0 API: ", (Throwable)e);
            throw new FailedDependencyException("Something went wrong while accessing the Auth0 API");
        }
    }

    public User getUser(String id) throws FailedDependencyException {
        try {
            ManagementAPI api = this.mgmtApi();
            Request request = api.users().get(id, new UserFilter());
            return (User)request.execute();
        }
        catch (Auth0Exception e) {
            logger.error("Error while calling Auth0 API: ", (Throwable)e);
            throw new FailedDependencyException("Something went wrong while accessing the Auth0 API");
        }
    }

    public User create(User user) throws FailedDependencyException {
        try {
            ManagementAPI api = this.mgmtApi();
            Request request = api.users().create(user);
            return (User)request.execute();
        }
        catch (Auth0Exception e) {
            logger.error("Error while calling Auth0 API: ", (Throwable)e);
            throw new FailedDependencyException("Something went wrong while accessing the Auth0 API");
        }
    }

    public User update(User user) throws FailedDependencyException {
        try {
            ManagementAPI api = this.mgmtApi();
            Request request = api.users().update(user.getId(), user);
            return (User)request.execute();
        }
        catch (Auth0Exception e) {
            logger.error("Error while calling Auth0 API: ", (Throwable)e);
            throw new FailedDependencyException("Something went wrong while accessing the Auth0 API");
        }
    }

    private ManagementAPI mgmtApi() throws FailedDependencyException {
        TokenHolder token = this.getToken();
        return new ManagementAPI(this.auth0Config.getDomain(), this.auth0Config.getTestToken());
    }

    private TokenHolder getToken() throws FailedDependencyException {
        if (this.cachedToken != null && this.cachedToken.getExpiresIn() > 0L) {
            logger.debug("Auth0 Mgmt API Token not yet expired, using this one...");
            return this.cachedToken;
        }
        try {
            logger.debug("Auth0 Mgmt API Token expired, going to fetch new one...");
            AuthRequest authRequest = this.authApi.requestToken(this.auth0Config.getApiAudience());
            this.cachedToken = (TokenHolder)authRequest.execute();
            return this.cachedToken;
        }
        catch (Auth0Exception e) {
            logger.error("Error while calling Auth0 API: ", (Throwable)e);
            throw new FailedDependencyException("Something went wrong while accessing the Auth0 API");
        }
    }
}

