/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.auth0.spring;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.inmanlabs.commons.auth0.spring.BearerSecurityContextRepository;
import com.inmanlabs.commons.auth0.spring.JwtAuthenticationEntryPoint;
import com.inmanlabs.commons.auth0.spring.JwtAuthenticationProvider;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.context.SecurityContextRepository;

public class JwtWebSecurityConfigurer {
    final String audience;
    final String issuer;
    final AuthenticationProvider provider;

    private JwtWebSecurityConfigurer(String audience, String issuer, AuthenticationProvider authenticationProvider) {
        this.audience = audience;
        this.issuer = issuer;
        this.provider = authenticationProvider;
    }

    public static JwtWebSecurityConfigurer forRS256(String audience, String issuer) {
        JwkProvider jwkProvider = new JwkProviderBuilder(issuer).build();
        return new JwtWebSecurityConfigurer(audience, issuer, new JwtAuthenticationProvider(jwkProvider, issuer, audience));
    }

    public static JwtWebSecurityConfigurer forRS256(String audience, String issuer, AuthenticationProvider provider) {
        return new JwtWebSecurityConfigurer(audience, issuer, provider);
    }

    public static JwtWebSecurityConfigurer forHS256WithBase64Secret(String audience, String issuer, String secret) {
        byte[] secretBytes = new Base64(true).decode(secret);
        return new JwtWebSecurityConfigurer(audience, issuer, new JwtAuthenticationProvider(secretBytes, issuer, audience));
    }

    public static JwtWebSecurityConfigurer forHS256(String audience, String issuer, byte[] secret) {
        return new JwtWebSecurityConfigurer(audience, issuer, new JwtAuthenticationProvider(secret, issuer, audience));
    }

    public static JwtWebSecurityConfigurer forHS256(String audience, String issuer, AuthenticationProvider provider) {
        return new JwtWebSecurityConfigurer(audience, issuer, provider);
    }

    public HttpSecurity configure(HttpSecurity http) throws Exception {
        return (HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.authenticationProvider(this.provider).securityContext().securityContextRepository((SecurityContextRepository)new BearerSecurityContextRepository()).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new JwtAuthenticationEntryPoint()).and()).httpBasic().disable()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and();
    }
}

