/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingRequestInterceptor
implements ClientHttpRequestInterceptor {
    static final Logger log = LoggerFactory.getLogger(LoggingRequestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.traceResponse(response);
        return response;
    }

    private void traceRequest(HttpRequest request, byte[] body) throws IOException {
        log.info("===========================request begin================================================");
        log.info("URI         : {}", (Object)request.getURI());
        log.info("Method      : {}", (Object)request.getMethod());
        log.info("Headers     : {}", (Object)request.getHeaders());
        log.info("Request body: {}", (Object)new String(body, "UTF-8"));
        log.info("==========================request end================================================");
    }

    private void traceResponse(ClientHttpResponse response) throws IOException {
        StringBuilder inputStringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
        String line = bufferedReader.readLine();
        while (line != null) {
            inputStringBuilder.append(line);
            inputStringBuilder.append('\n');
            line = bufferedReader.readLine();
        }
        log.info("============================response begin==========================================");
        log.info("Status code  : {}", (Object)response.getStatusCode());
        log.info("Status text  : {}", (Object)response.getStatusText());
        log.info("Headers      : {}", (Object)response.getHeaders());
        log.info("Response body: {}", (Object)inputStringBuilder.toString());
        log.info("=======================response end=================================================");
    }
}

