/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.twilio;

import com.inmanlabs.commons.twilio.TwilioConfig;
import com.inmanlabs.commons.twilio.TwilioMessage;
import com.inmanlabs.commons.twilio.TwilioMessageLog;
import com.inmanlabs.commons.twilio.TwilioMessageLogRepository;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import com.twilio.Twilio;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.rest.api.v2010.account.MessageCreator;
import com.twilio.type.PhoneNumber;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TwilioClient {
    private static Logger logger = LoggerFactory.getLogger(TwilioClient.class);
    @Resource
    private TwilioConfig twilioConfig;
    @Resource
    private TwilioMessageLogRepository twilioMessageLogRepository;

    @PostConstruct
    public void initializeTwilio() {
        Twilio.init((String)this.twilioConfig.getAccountSid(), (String)this.twilioConfig.getAuthToken());
    }

    public TwilioMessageLog send(TwilioMessage message) throws FailedDependencyException {
        return this.send(message.getTo(), this.twilioConfig.getDefaultNumber(), message.getBody());
    }

    TwilioMessageLog send(String to, String from, String body) throws FailedDependencyException {
        Message sentMessage;
        MessageCreator messageCreator = Message.creator((PhoneNumber)new PhoneNumber(to), (PhoneNumber)new PhoneNumber(from), (String)body);
        logger.info(String.format("Sending %s characters from %s to %s", body.length(), from, to));
        logger.debug(String.format("Full message: %s", body));
        try {
            sentMessage = (Message)messageCreator.create();
        }
        catch (ApiException e) {
            logger.error("Error occurred while interacting with Twilio API", (Throwable)e);
            throw new FailedDependencyException("Error while interacting with Twilio API: ", e);
        }
        logger.info("Message ID: " + sentMessage.getSid());
        TwilioMessageLog log = new TwilioMessageLog(sentMessage);
        return (TwilioMessageLog)this.twilioMessageLogRepository.save(log);
    }
}

