/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.user;

import com.auth0.client.mgmt.filter.UserFilter;
import com.auth0.json.mgmt.users.User;
import com.auth0.json.mgmt.users.UsersPage;
import com.inmanlabs.commons.auth0.Auth0Client;
import com.inmanlabs.commons.user.UserRepository;
import com.inmanlabs.commons.web.error.FailedDependencyException;
import com.inmanlabs.commons.web.error.NotFoundException;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private Logger logger = LoggerFactory.getLogger(UserService.class);
    private static String ANONYMOUS_USER_KEY = "anonymousUser";
    @Resource
    private UserRepository userRepository;
    @Resource
    private Auth0Client auth0Client;

    public User currentUser() throws FailedDependencyException, NotFoundException {
        String currentUserId = SecurityContextHolder.getContext().getAuthentication().getName();
        if (currentUserId == null || StringUtils.equals((CharSequence)currentUserId, (CharSequence)ANONYMOUS_USER_KEY)) {
            throw new NotFoundException("No user is currently logged in.");
        }
        return this.load(currentUserId);
    }

    public User load(String id) throws FailedDependencyException {
        return this.auth0Client.getUser(id);
    }

    public User findByPhone(String phoneNumber) throws FailedDependencyException {
        UserFilter filter = new UserFilter();
        filter.withQuery("phone_number:\"" + phoneNumber + "\"");
        UsersPage usersPage = this.auth0Client.list(filter);
        if (usersPage == null || usersPage.getLength() == null || usersPage.getLength() == 0) {
            return null;
        }
        if (usersPage.getLength() > 1) {
            this.logger.error("We got more than one user when searching by phone number, this should not happen: " + Arrays.toString(usersPage.getItems().toArray()));
            throw new FailedDependencyException("There seems to be a problem with the auth0 filter");
        }
        return (User)usersPage.getItems().get(0);
    }

    public User put(String firstName, String lastName, String phoneNumber) throws FailedDependencyException {
        User user = this.findByPhone(phoneNumber);
        if (user == null) {
            return this.create(firstName, lastName, phoneNumber);
        }
        return this.update(user);
    }

    public User update(User user) throws FailedDependencyException {
        User loadedUser = this.load(user.getId());
        if (!StringUtils.equals((CharSequence)loadedUser.getFamilyName(), (CharSequence)user.getFamilyName()) || !StringUtils.equals((CharSequence)user.getGivenName(), (CharSequence)loadedUser.getGivenName())) {
            loadedUser.setFamilyName(user.getFamilyName());
            loadedUser.setGivenName(user.getGivenName());
            return this.auth0Client.update(user);
        }
        return loadedUser;
    }

    public User create(String firstName, String lastName, String phone) throws FailedDependencyException {
        User user = new User();
        user.setGivenName(firstName);
        user.setFamilyName(lastName);
        user.setPhoneNumber(phone);
        user.setPhoneVerified(Boolean.valueOf(true));
        user.setConnection("sms");
        return this.auth0Client.create(user);
    }
}

