/*
 * Decompiled with CFR 0.152.
 */
package com.inmanlabs.commons.web;

import com.inmanlabs.commons.web.ApiError;
import com.inmanlabs.commons.web.ApiResponseStatus;
import com.inmanlabs.commons.web.error.NotFoundException;
import java.util.Optional;
import java.util.UUID;
import org.springframework.http.HttpStatus;

public class ApiResponse<T> {
    private ApiResponseStatus status;
    private T data;
    private ApiError error;

    public ApiResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(ApiResponseStatus status) {
        this.status = status;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ApiError getError() {
        return this.error;
    }

    public void setError(ApiError error) {
        this.error = error;
    }

    public static <T> ApiResponse<T> fromOptional(Optional<T> optionalData) throws NotFoundException {
        if (!optionalData.isPresent()) {
            throw new NotFoundException(optionalData.getClass().getSimpleName() + " not found");
        }
        return ApiResponse.success(optionalData.get());
    }

    public static <T> ApiResponse<T> success(T data) {
        ApiResponse<T> response = new ApiResponse<T>();
        response.setStatus(ApiResponseStatus.success);
        response.setData(data);
        return response;
    }

    public static <T> ApiResponse<T> error(String message, int status) {
        ApiResponse<T> response = new ApiResponse<T>();
        response.setStatus(ApiResponseStatus.error);
        ApiError error = new ApiError();
        error.setId(UUID.randomUUID().toString());
        error.setMessage(message);
        error.setStatus(status);
        response.setError(error);
        return response;
    }

    public static <T> ApiResponse<T> fail(String message) {
        ApiResponse<T> response = new ApiResponse<T>();
        response.setStatus(ApiResponseStatus.fail);
        ApiError error = new ApiError();
        error.setId(UUID.randomUUID().toString());
        error.setMessage(message);
        error.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setError(error);
        return response;
    }

    public String toString() {
        return "ApiResponse{status=" + (Object)((Object)this.status) + ", data=" + this.data + ", error=" + this.error + '}';
    }
}

