/*
 * Decompiled with CFR 0.152.
 */
package pub.dtm.client;

import com.alibaba.nacos.api.naming.pojo.Instance;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pub.dtm.client.feign.DtmFeignClient;
import pub.dtm.client.feign.URIParser;
import pub.dtm.client.interfaces.ICommunicationStub;
import pub.dtm.client.interfaces.dtm.DtmConsumer;
import pub.dtm.client.interfaces.feign.IDtmFeignClient;
import pub.dtm.client.properties.DtmProperties;
import pub.dtm.client.saga.Saga;
import pub.dtm.client.tcc.Tcc;
import pub.dtm.client.utils.NacosUtils;

public class DtmClient {
    private static final Logger log = LoggerFactory.getLogger(DtmClient.class);
    private ICommunicationStub communicationStub;

    public DtmClient() {
        IDtmFeignClient feignClient;
        new URIParser();
        String endpoint = null;
        try {
            endpoint = DtmProperties.get("dtm.ipport");
            if (StringUtils.isEmpty((CharSequence)endpoint)) {
                Instance instance = NacosUtils.selectOneHealthyInstance(DtmProperties.get("dtm.service.name"), DtmProperties.getOrDefault("groupName", "DEFAULT_GROUP"), this.genClusters(DtmProperties.get("clusterName")));
                endpoint = instance.toInetAddr();
            }
        }
        catch (Exception e) {
            log.error("initial dtm client for java error.", (Throwable)e);
            System.exit(-1);
        }
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            log.error("can not resolve dtm server message from config file, you can use nacos or redirect configure to config it.");
            System.exit(-1);
        }
        if ((feignClient = (IDtmFeignClient)Feign.builder().decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new JacksonEncoder()).target(DtmFeignClient.class, "http://" + endpoint)) == null) {
            log.error("initial dtm client for java error, feign client can't be null.");
            System.exit(-1);
        }
        this.communicationStub = feignClient;
    }

    public DtmClient(String endpoint) {
        IDtmFeignClient feignClient;
        new URIParser();
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            log.error("dtm server endpoint can not be empty.");
            System.exit(-1);
        }
        if ((feignClient = (IDtmFeignClient)Feign.builder().decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new JacksonEncoder()).target(DtmFeignClient.class, "http://" + endpoint)) == null) {
            log.error("initial dtm client for java error, feign client can't be null.");
            System.exit(-1);
        }
        this.communicationStub = feignClient;
    }

    private List<String> genClusters(String clusterStr) {
        if (StringUtils.isEmpty((CharSequence)clusterStr)) {
            ArrayList<String> clusters = new ArrayList<String>();
            clusters.add("DEFAULT");
            return clusters;
        }
        String[] split = StringUtils.split((String)clusterStr, (String)",");
        return Arrays.asList(split);
    }

    public String tccGlobalTransaction(DtmConsumer<Tcc> function) throws Exception {
        Tcc tcc = new Tcc(null, this.communicationStub);
        return tcc.tccGlobalTransaction(function);
    }

    public String tccGlobalTransaction(String gid, DtmConsumer<Tcc> function) throws Exception {
        Tcc tcc = new Tcc(gid, this.communicationStub);
        return tcc.tccGlobalTransaction(function);
    }

    public Saga newSaga(String gid) {
        return new Saga(gid, this.communicationStub);
    }

    public Saga newSaga() {
        return new Saga(null, this.communicationStub);
    }
}

