/*
 * Decompiled with CFR 0.152.
 */
package me.eXo8_.fakeentity.core;

import com.comphenix.protocol.ProtocolLibrary;
import me.eXo8_.fakeentity.api.IEntityHandler;
import me.eXo8_.fakeentity.nms.nms_1_21_4.listener.NMSListenerImpl;
import me.eXo8_.fakeentity.nms.nms_1_21_5.IEntityHandlerImpl;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FakeEntityAPI {
    public static final String PREFIX = "[FakeEntityAPI] ";
    private static JavaPlugin plugin;
    private static IEntityHandler iEntityHandler;

    public static void init(JavaPlugin plugin) {
        FakeEntityAPI.plugin = plugin;
        if (ProtocolLibrary.getProtocolManager() == null) {
            FakeEntityAPI.severe("==========================================");
            FakeEntityAPI.severe("  FakeEntityAPI: ProtocolLib dependency not found!");
            FakeEntityAPI.severe("==========================================");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        String numericVersion = plugin.getServer().getBukkitVersion().split("-")[0];
        FakeEntityAPI.info("Detected version - " + numericVersion);
        NMSListenerImpl nmsListener = null;
        if ("1.21.4".equals(numericVersion)) {
            iEntityHandler = me.eXo8_.fakeentity.nms.nms_1_21_4.IEntityHandlerImpl.getInstance();
            nmsListener = new NMSListenerImpl(plugin, iEntityHandler);
        } else if ("1.21.5".equals(numericVersion)) {
            iEntityHandler = IEntityHandlerImpl.getInstance();
            nmsListener = new me.eXo8_.fakeentity.nms.nms_1_21_5.listener.NMSListenerImpl(plugin, iEntityHandler);
        } else {
            FakeEntityAPI.severe("==========================================");
            FakeEntityAPI.severe("  FakeEntityAPI: Unsupported Minecraft version!");
            FakeEntityAPI.severe("  Detected: " + numericVersion);
            FakeEntityAPI.severe("  Minimum supported version: 1.21.4");
            FakeEntityAPI.severe("  Please update your server to continue using this plugin.");
            FakeEntityAPI.severe("==========================================");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        if (nmsListener == null) {
            FakeEntityAPI.severe("==========================================");
            FakeEntityAPI.severe("  FakeEntityAPI: NMSListener is null!");
            FakeEntityAPI.severe("  Detected: " + numericVersion);
            FakeEntityAPI.severe("  Initialization failed!");
            FakeEntityAPI.severe("==========================================");
            plugin.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        nmsListener.register();
    }

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    public static IEntityHandler getFakeEntityManager() {
        return iEntityHandler;
    }

    public static void info(String str) {
        plugin.getServer().getLogger().info(PREFIX + str);
    }

    public static void warning(String str) {
        plugin.getServer().getLogger().warning(PREFIX + str);
    }

    public static void severe(String str) {
        plugin.getServer().getLogger().severe(PREFIX + str);
    }
}

