/*
 * Decompiled with CFR 0.152.
 */
package io.github.farleychen.fastcdc;

import java.util.Arrays;
import java.util.Objects;

public final class Chunk {
    private final long offset;
    private final int length;
    private final byte[] data;
    private final String hash;

    public byte[] getData() {
        return Objects.requireNonNull(this.data);
    }

    public String getHash() {
        return Objects.requireNonNull(this.hash);
    }

    public Chunk(long offset, int length, byte[] data, String hash) {
        this.offset = offset;
        this.length = length;
        this.data = data;
        this.hash = hash;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + this.getLength();
        result = result * 59 + Arrays.hashCode(this.getData());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }

    public String toString() {
        return "Chunk(offset=" + this.getOffset() + ", length=" + this.getLength() + ", data=" + Arrays.toString(this.getData()) + ", hash=" + this.getHash() + ")";
    }
}

