/*
 * Decompiled with CFR 0.152.
 */
package io.github.farleychen.fastcdc;

import io.github.farleychen.fastcdc.Assert;
import io.github.farleychen.fastcdc.Chunk;
import io.github.farleychen.fastcdc.Const;
import io.github.farleychen.fastcdc.RingByteArray;
import io.github.farleychen.fastcdc.Utils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Function;

public class ChunkIterator
implements Iterator<Chunk> {
    private final InputStream stream;
    private final int centerSize;
    private final int maskS;
    private final int maskL;
    private final int readSize;
    private final RingByteArray blob;
    private long offset;
    private final int minSize;
    private final int avgSize;
    private final int maxSize;
    private final boolean fetchData;
    private final Function<byte[], String> hashFunction;

    ChunkIterator(InputStream stream, int minSize, int avgSize, int maxSize, boolean fetchData, Function<byte[], String> hashFunction) {
        Assert.isTrue(stream != null);
        Assert.isTrue(minSize > 0);
        Assert.isTrue(avgSize > 0);
        Assert.isTrue(maxSize > 0);
        Assert.isTrue(minSize <= avgSize);
        Assert.isTrue(avgSize <= maxSize);
        Assert.isTrue(minSize >= 64);
        Assert.isTrue(minSize <= 0x4000000);
        Assert.isTrue(avgSize >= 256);
        Assert.isTrue(avgSize <= 0x10000000);
        Assert.isTrue(maxSize >= 1024);
        Assert.isTrue(maxSize <= 0x40000000);
        this.stream = stream;
        this.minSize = minSize;
        this.avgSize = avgSize;
        this.maxSize = maxSize;
        this.fetchData = fetchData;
        this.hashFunction = hashFunction;
        this.centerSize = Utils.centerSize(avgSize, minSize, maxSize);
        int bits = Utils.logarithm2(avgSize);
        this.maskS = Utils.mask(bits + 1);
        this.maskL = Utils.mask(bits - 1);
        this.readSize = Math.max(65536, maxSize);
        this.blob = new RingByteArray(this.readSize * 2);
        this.blob.addAll(Utils.readNBytes(stream, this.readSize));
        this.offset = 0L;
    }

    @Override
    public boolean hasNext() {
        return !this.blob.isEmpty();
    }

    @Override
    public Chunk next() {
        byte[] data;
        if (this.blob.size() <= this.maxSize) {
            this.blob.addAll(Utils.readNBytes(this.stream, this.readSize));
        }
        int chunkLength = this.cdcOffset(this.blob, this.minSize, this.avgSize, this.maxSize, this.centerSize, this.maskS, this.maskL);
        byte[] byArray = data = this.fetchData ? this.blob.getRange(0, chunkLength) : null;
        String hash = this.hashFunction != null ? (data != null ? this.hashFunction.apply(data) : this.hashFunction.apply(this.blob.getRange(0, chunkLength))) : null;
        Chunk chunk = new Chunk(this.offset, chunkLength, data, hash);
        this.offset += (long)chunkLength;
        this.blob.position(chunkLength);
        return chunk;
    }

    private int cdcOffset(RingByteArray blob, int minSize, int avgSize, int maxSize, int centerSize, int maskS, int maskL) {
        int index;
        if (blob.size() < minSize) {
            return blob.size();
        }
        int pattern = 0;
        int size = blob.size();
        int barrier = Math.min(centerSize, size);
        for (index = minSize; index < barrier; ++index) {
            if (((pattern = (pattern >>> 1) + Const.GEAR[Byte.toUnsignedInt(blob.get(index))]) & maskS) != 0) continue;
            return index + 1;
        }
        barrier = Math.min(maxSize, size);
        while (index < barrier) {
            if (((pattern = (pattern >>> 1) + Const.GEAR[Byte.toUnsignedInt(blob.get(index))]) & maskL) == 0) {
                return index + 1;
            }
            ++index;
        }
        return index;
    }
}

