/*
 * Decompiled with CFR 0.152.
 */
package io.github.farleychen.fastcdc;

import java.util.function.Function;

public class FastCDCOption {
    private int minSize = -1;
    private int avgSize = 8192;
    private int maxSize = -1;
    private boolean fetchData = false;
    private Function<byte[], String> hashFunction = null;

    public int getMinSize() {
        return this.minSize == -1 ? this.avgSize / 4 : this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize == -1 ? this.avgSize * 8 : this.maxSize;
    }

    public int getAvgSize() {
        return this.avgSize;
    }

    public boolean isFetchData() {
        return this.fetchData;
    }

    public Function<byte[], String> getHashFunction() {
        return this.hashFunction;
    }

    public FastCDCOption setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public FastCDCOption setAvgSize(int avgSize) {
        this.avgSize = avgSize;
        return this;
    }

    public FastCDCOption setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public FastCDCOption setFetchData(boolean fetchData) {
        this.fetchData = fetchData;
        return this;
    }

    public FastCDCOption setHashFunction(Function<byte[], String> hashFunction) {
        this.hashFunction = hashFunction;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FastCDCOption)) {
            return false;
        }
        FastCDCOption other = (FastCDCOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getAvgSize() != other.getAvgSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.isFetchData() != other.isFetchData()) {
            return false;
        }
        Function<byte[], String> this$hashFunction = this.getHashFunction();
        Function<byte[], String> other$hashFunction = other.getHashFunction();
        return !(this$hashFunction == null ? other$hashFunction != null : !this$hashFunction.equals(other$hashFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FastCDCOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getAvgSize();
        result = result * 59 + this.getMaxSize();
        result = result * 59 + (this.isFetchData() ? 79 : 97);
        Function<byte[], String> $hashFunction = this.getHashFunction();
        result = result * 59 + ($hashFunction == null ? 43 : $hashFunction.hashCode());
        return result;
    }

    public String toString() {
        return "FastCDCOption(minSize=" + this.getMinSize() + ", avgSize=" + this.getAvgSize() + ", maxSize=" + this.getMaxSize() + ", fetchData=" + this.isFetchData() + ", hashFunction=" + String.valueOf(this.getHashFunction()) + ")";
    }
}

