/*
 * Decompiled with CFR 0.152.
 */
package io.github.farleychen.fastcdc;

import io.github.farleychen.fastcdc.ArrayUtils;
import io.github.farleychen.fastcdc.Assert;

class RingByteArray {
    private final byte[] elements;
    private int size = 0;
    private int firstElementIndex = 0;
    private int addElementIndex = 0;

    RingByteArray(int capacity) {
        Assert.isTrue(capacity >= 0);
        this.elements = new byte[capacity];
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    int size() {
        return this.size;
    }

    void addAll(byte[] bytes) {
        for (byte aByte : bytes) {
            this.add(aByte);
        }
    }

    void add(byte aByte) {
        if (this.size == this.elements.length) {
            throw new RuntimeException("Ring byte array overflow");
        }
        this.elements[this.addElementIndex] = aByte;
        this.addElementIndex = (this.addElementIndex + 1) % this.elements.length;
        ++this.size;
    }

    void position(int index) {
        Assert.isTrue(index >= 0);
        if (index > this.size) {
            throw new RuntimeException("Ring byte array underflow");
        }
        this.firstElementIndex = (this.firstElementIndex + index) % this.elements.length;
        this.size -= index;
    }

    byte get(int index) {
        Assert.isTrue(index >= 0);
        if (index >= this.size) {
            throw new RuntimeException("Ring byte array underflow");
        }
        return this.elements[(this.firstElementIndex + index) % this.elements.length];
    }

    byte[] getRange(int fromInclusive, int toExclusive) {
        Assert.isTrue(fromInclusive >= 0);
        Assert.isTrue(fromInclusive <= toExclusive);
        if (fromInclusive >= this.size || toExclusive > this.size) {
            throw new RuntimeException("Ring byte array underflow");
        }
        if (fromInclusive == toExclusive) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        int from = (this.firstElementIndex + fromInclusive) % this.elements.length;
        int to = (this.firstElementIndex + toExclusive) % this.elements.length;
        if (from < to) {
            return ArrayUtils.subarray(this.elements, from, to);
        }
        return ArrayUtils.addAll(ArrayUtils.subarray(this.elements, from, this.elements.length), ArrayUtils.subarray(this.elements, 0, to));
    }
}

