/*
 * Decompiled with CFR 0.152.
 */
package io.github.farleychen.fastcdc;

import io.github.farleychen.fastcdc.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

final class Utils {
    Utils() {
    }

    static byte[] readNBytes(InputStream stream, int readSize) {
        byte[] bytes;
        try {
            bytes = stream.readNBytes(readSize);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bytes;
    }

    static int logarithm2(int value) {
        return (int)Math.round(Math.log(value) / Math.log(2.0));
    }

    static int mask(int bits) {
        Assert.isTrue(bits >= 1);
        Assert.isTrue(bits <= 31);
        return (int)(Math.pow(2.0, bits) - 1.0);
    }

    static int centerSize(int average, int minimum, int sourceSize) {
        int offset = minimum + Utils.ceilDiv(minimum, 2);
        if (offset > average) {
            offset = average;
        }
        int size = average - offset;
        return Math.min(size, sourceSize);
    }

    static int ceilDiv(int x, int y) {
        return (x + y - 1) / y;
    }
}

