/*
 * Decompiled with CFR 0.152.
 */
package com._4paradigm.flowengine.pipeline.mock;

import com._4paradigm.flowengine.pipeline.core.FLFunction;
import com._4paradigm.flowengine.pipeline.core.PipelineContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSleepFunction
extends FLFunction {
    private static final Logger log = LoggerFactory.getLogger(MockSleepFunction.class);
    private int duration;

    public void onInit(Map<String, Object> initConfig) {
        this.duration = (Integer)initConfig.getOrDefault("duration", 100);
    }

    public Object run(PipelineContext context, Object ... args) {
        log.error("func key: {}, start to sleep for {} ms", (Object)this.getKey(), (Object)this.duration);
        try {
            TimeUnit.MILLISECONDS.sleep(this.duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.error("func key: {}, finish sleep for {} ms", (Object)this.getKey(), (Object)this.duration);
        return String.format("sleep %s ms", this.duration);
    }
}

