package forsyde.io.java.core;

import java.lang.String;

public enum EdgeTrait implements Trait {
  MOC_LINGUAFRANCA_CONTAINMENTEDGE("moc::linguafranca::ContainmentEdge"),

  MOC_LINGUAFRANCA_EVENTEDGE("moc::linguafranca::EventEdge"),

  MOC_SDF_SDFDATAEDGE("moc::sdf::SDFDataEdge"),

  EXECUTION_CONTAINMENTEDGE("execution::ContainmentEdge"),

  EXECUTION_CONSTRAINTEDGE("execution::ConstraintEdge"),

  EXECUTION_COMMUNICATIONEDGE("execution::CommunicationEdge"),

  EXECUTION_EVENTEDGE("execution::EventEdge"),

  PLATFORM_STRUCTURALCONNECTION("platform::StructuralConnection"),

  PLATFORM_PHYSICALCONNECTION("platform::PhysicalConnection"),

  DECISION_ABSTRACTMAPPING("decision::AbstractMapping"),

  DECISION_ABSTRACTALLOCATION("decision::AbstractAllocation"),

  DECISION_ABSTRACTSCHEDULING("decision::AbstractScheduling"),

  VISUALIZATION_VISUALCONTAINMENT("visualization::VisualContainment"),

  VISUALIZATION_VISUALCONNECTION("visualization::VisualConnection");

  private final String canonicalName;

  EdgeTrait(String canonicalName) {
    this.canonicalName = canonicalName;
  }

  public static boolean refines(EdgeTrait one, EdgeTrait other) {
    switch (one) {
      case MOC_LINGUAFRANCA_CONTAINMENTEDGE:
      switch (other) {
        case MOC_LINGUAFRANCA_CONTAINMENTEDGE: return true;
        default: return false;
      }
      case MOC_LINGUAFRANCA_EVENTEDGE:
      switch (other) {
        case MOC_LINGUAFRANCA_EVENTEDGE: return true;
        default: return false;
      }
      case MOC_SDF_SDFDATAEDGE:
      switch (other) {
        case MOC_SDF_SDFDATAEDGE: return true;
        default: return false;
      }
      case EXECUTION_CONTAINMENTEDGE:
      switch (other) {
        case EXECUTION_CONTAINMENTEDGE: return true;
        default: return false;
      }
      case EXECUTION_CONSTRAINTEDGE:
      switch (other) {
        case EXECUTION_CONSTRAINTEDGE: return true;
        default: return false;
      }
      case EXECUTION_COMMUNICATIONEDGE:
      switch (other) {
        case EXECUTION_COMMUNICATIONEDGE: return true;
        default: return false;
      }
      case EXECUTION_EVENTEDGE:
      switch (other) {
        case EXECUTION_EVENTEDGE: return true;
        default: return false;
      }
      case PLATFORM_STRUCTURALCONNECTION:
      switch (other) {
        case PLATFORM_STRUCTURALCONNECTION: return true;
        default: return false;
      }
      case PLATFORM_PHYSICALCONNECTION:
      switch (other) {
        case PLATFORM_PHYSICALCONNECTION: return true;
        default: return false;
      }
      case DECISION_ABSTRACTMAPPING:
      switch (other) {
        case DECISION_ABSTRACTMAPPING: return true;
        default: return false;
      }
      case DECISION_ABSTRACTALLOCATION:
      switch (other) {
        case DECISION_ABSTRACTALLOCATION: return true;
        default: return false;
      }
      case DECISION_ABSTRACTSCHEDULING:
      switch (other) {
        case DECISION_ABSTRACTSCHEDULING: return true;
        default: return false;
      }
      case VISUALIZATION_VISUALCONTAINMENT:
      switch (other) {
        case VISUALIZATION_VISUALCONTAINMENT: return true;
        default: return false;
      }
      case VISUALIZATION_VISUALCONNECTION:
      switch (other) {
        case VISUALIZATION_VISUALCONNECTION: return true;
        default: return false;
      }
      default: return false;
    }
  }

  public boolean refines(Trait other) {
    return other instanceof EdgeTrait ? EdgeTrait.refines(this, (EdgeTrait) other) : false;
  }

  public static Trait fromName(String traitName) {
    switch (traitName) {
      case "moc::linguafranca::ContainmentEdge":
      case "MOC_LINGUAFRANCA_CONTAINMENTEDGE": return EdgeTrait.MOC_LINGUAFRANCA_CONTAINMENTEDGE;
      case "moc::linguafranca::EventEdge":
      case "MOC_LINGUAFRANCA_EVENTEDGE": return EdgeTrait.MOC_LINGUAFRANCA_EVENTEDGE;
      case "moc::sdf::SDFDataEdge":
      case "MOC_SDF_SDFDATAEDGE": return EdgeTrait.MOC_SDF_SDFDATAEDGE;
      case "execution::ContainmentEdge":
      case "EXECUTION_CONTAINMENTEDGE": return EdgeTrait.EXECUTION_CONTAINMENTEDGE;
      case "execution::ConstraintEdge":
      case "EXECUTION_CONSTRAINTEDGE": return EdgeTrait.EXECUTION_CONSTRAINTEDGE;
      case "execution::CommunicationEdge":
      case "EXECUTION_COMMUNICATIONEDGE": return EdgeTrait.EXECUTION_COMMUNICATIONEDGE;
      case "execution::EventEdge":
      case "EXECUTION_EVENTEDGE": return EdgeTrait.EXECUTION_EVENTEDGE;
      case "platform::StructuralConnection":
      case "PLATFORM_STRUCTURALCONNECTION": return EdgeTrait.PLATFORM_STRUCTURALCONNECTION;
      case "platform::PhysicalConnection":
      case "PLATFORM_PHYSICALCONNECTION": return EdgeTrait.PLATFORM_PHYSICALCONNECTION;
      case "decision::AbstractMapping":
      case "DECISION_ABSTRACTMAPPING": return EdgeTrait.DECISION_ABSTRACTMAPPING;
      case "decision::AbstractAllocation":
      case "DECISION_ABSTRACTALLOCATION": return EdgeTrait.DECISION_ABSTRACTALLOCATION;
      case "decision::AbstractScheduling":
      case "DECISION_ABSTRACTSCHEDULING": return EdgeTrait.DECISION_ABSTRACTSCHEDULING;
      case "visualization::VisualContainment":
      case "VISUALIZATION_VISUALCONTAINMENT": return EdgeTrait.VISUALIZATION_VISUALCONTAINMENT;
      case "visualization::VisualConnection":
      case "VISUALIZATION_VISUALCONNECTION": return EdgeTrait.VISUALIZATION_VISUALCONNECTION;
      default: return new OpaqueTrait(traitName);
    }
  }

  public String getName() {
    return canonicalName;
  }
}
