package forsyde.io.java.core;

import java.lang.String;

public enum VertexTrait implements Trait {
  IMPL_EXECUTABLE("impl::Executable"),

  IMPL_INSTRUMENTEDEXECUTABLE("impl::InstrumentedExecutable"),

  MOC_MOCELEM("moc::MoCElem"),

  MOC_LINGUAFRANCA_LINGUAFRANCAELEM("moc::linguafranca::LinguaFrancaElem"),

  MOC_LINGUAFRANCA_LINGUAFRANCATIMER("moc::linguafranca::LinguaFrancaTimer"),

  MOC_LINGUAFRANCA_LINGUAFRANCAREACTION("moc::linguafranca::LinguaFrancaReaction"),

  MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR("moc::linguafranca::LinguaFrancaReactor"),

  MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL("moc::linguafranca::LinguaFrancaSignal"),

  MOC_SDF_SDFELEM("moc::sdf::SDFElem"),

  MOC_SDF_SDFCOMB("moc::sdf::SDFComb"),

  MOC_SDF_SDFDELAY("moc::sdf::SDFDelay"),

  MOC_SDF_SDFCHANNEL("moc::sdf::SDFChannel"),

  EXECUTION_STIMULUS("execution::Stimulus"),

  EXECUTION_PERIODICSTIMULUS("execution::PeriodicStimulus"),

  EXECUTION_TASK("execution::Task"),

  EXECUTION_CONSTRAINEDTASK("execution::ConstrainedTask"),

  EXECUTION_PERIODICTASK("execution::PeriodicTask"),

  EXECUTION_CHANNEL("execution::Channel"),

  EXECUTION_RUNTIMECONSTRAINT("execution::RuntimeConstraint"),

  EXECUTION_PRECEDENCECONSTRAINT("execution::PrecedenceConstraint"),

  EXECUTION_EXTENDEDPRECEDENCECONSTRAINT("execution::ExtendedPrecedenceConstraint"),

  EXECUTION_COLOCATIONCONSTRAINT("execution::ColocationConstraint"),

  PLATFORM_PLATFORMELEM("platform::PlatformElem"),

  PLATFORM_ABSTRACTSTRUCTURE("platform::AbstractStructure"),

  PLATFORM_DIGITALMODULE("platform::DigitalModule"),

  PLATFORM_SYNTHETIZABLEDIGITALPORTS("platform::SynthetizableDigitalPorts"),

  PLATFORM_GENERICPROCESSINGMODULE("platform::GenericProcessingModule"),

  PLATFORM_GENERICCOMMUNICATIONMODULE("platform::GenericCommunicationModule"),

  PLATFORM_GENERICMEMORYMODULE("platform::GenericMemoryModule"),

  PLATFORM_GENERICCACHEMODULE("platform::GenericCacheModule"),

  PLATFORM_INSTRUMENTEDPROCESSINGMODULE("platform::InstrumentedProcessingModule"),

  PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE("platform::InstrumentedCommunicationModule"),

  PLATFORM_ROUNDROBINCOMMUNICATIONMODULE("platform::RoundRobinCommunicationModule"),

  PLATFORM_RUNTIME_ABSTRACTSCHEDULER("platform::runtime::AbstractScheduler"),

  PLATFORM_RUNTIME_STATICCYCLICSCHEDULER("platform::runtime::StaticCyclicScheduler"),

  PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER("platform::runtime::FixedPriorityScheduler"),

  PLATFORM_RUNTIME_ROUNDROBINSCHEDULER("platform::runtime::RoundRobinScheduler"),

  PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER("platform::runtime::TimeTriggeredScheduler"),

  DECISION_ALLOCATED("decision::Allocated"),

  DECISION_MEMORYMAPPED("decision::MemoryMapped"),

  DECISION_SCHEDULED("decision::Scheduled"),

  DECISION_SDF_PASSEDSDFCOMB("decision::sdf::PASSedSDFComb"),

  DECISION_SDF_BOUNDEDSDFCHANNEL("decision::sdf::BoundedSDFChannel"),

  VISUALIZATION_VISUALIZABLE("visualization::Visualizable"),

  VISUALIZATION_POSITIONED("visualization::Positioned"),

  VISUALIZATION_GREYBOX("visualization::GreyBox");

  private final String canonicalName;

  VertexTrait(String canonicalName) {
    this.canonicalName = canonicalName;
  }

  public static boolean refines(VertexTrait one, VertexTrait other) {
    switch (one) {
      case IMPL_EXECUTABLE:
      switch (other) {
        case IMPL_EXECUTABLE: return true;
        default: return false;
      }
      case IMPL_INSTRUMENTEDEXECUTABLE:
      switch (other) {
        case IMPL_INSTRUMENTEDEXECUTABLE: return true;
        case IMPL_EXECUTABLE: return true;
        default: return false;
      }
      case MOC_MOCELEM:
      switch (other) {
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_LINGUAFRANCA_LINGUAFRANCAELEM:
      switch (other) {
        case MOC_LINGUAFRANCA_LINGUAFRANCAELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_LINGUAFRANCA_LINGUAFRANCATIMER:
      switch (other) {
        case MOC_LINGUAFRANCA_LINGUAFRANCATIMER: return true;
        case MOC_LINGUAFRANCA_LINGUAFRANCAELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_LINGUAFRANCA_LINGUAFRANCAREACTION:
      switch (other) {
        case MOC_LINGUAFRANCA_LINGUAFRANCAREACTION: return true;
        case MOC_LINGUAFRANCA_LINGUAFRANCAELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR:
      switch (other) {
        case MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR: return true;
        case MOC_LINGUAFRANCA_LINGUAFRANCAELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL:
      switch (other) {
        case MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL: return true;
        case MOC_LINGUAFRANCA_LINGUAFRANCAELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_SDF_SDFELEM:
      switch (other) {
        case MOC_SDF_SDFELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_SDF_SDFCOMB:
      switch (other) {
        case MOC_SDF_SDFCOMB: return true;
        case MOC_SDF_SDFELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_SDF_SDFDELAY:
      switch (other) {
        case MOC_SDF_SDFDELAY: return true;
        case MOC_SDF_SDFELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case MOC_SDF_SDFCHANNEL:
      switch (other) {
        case MOC_SDF_SDFCHANNEL: return true;
        case MOC_SDF_SDFELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case EXECUTION_STIMULUS:
      switch (other) {
        case EXECUTION_STIMULUS: return true;
        default: return false;
      }
      case EXECUTION_PERIODICSTIMULUS:
      switch (other) {
        case EXECUTION_PERIODICSTIMULUS: return true;
        case EXECUTION_STIMULUS: return true;
        default: return false;
      }
      case EXECUTION_TASK:
      switch (other) {
        case EXECUTION_TASK: return true;
        default: return false;
      }
      case EXECUTION_CONSTRAINEDTASK:
      switch (other) {
        case EXECUTION_CONSTRAINEDTASK: return true;
        default: return false;
      }
      case EXECUTION_PERIODICTASK:
      switch (other) {
        case EXECUTION_PERIODICTASK: return true;
        case EXECUTION_TASK: return true;
        default: return false;
      }
      case EXECUTION_CHANNEL:
      switch (other) {
        case EXECUTION_CHANNEL: return true;
        default: return false;
      }
      case EXECUTION_RUNTIMECONSTRAINT:
      switch (other) {
        case EXECUTION_RUNTIMECONSTRAINT: return true;
        default: return false;
      }
      case EXECUTION_PRECEDENCECONSTRAINT:
      switch (other) {
        case EXECUTION_PRECEDENCECONSTRAINT: return true;
        case EXECUTION_RUNTIMECONSTRAINT: return true;
        default: return false;
      }
      case EXECUTION_EXTENDEDPRECEDENCECONSTRAINT:
      switch (other) {
        case EXECUTION_EXTENDEDPRECEDENCECONSTRAINT: return true;
        case EXECUTION_PRECEDENCECONSTRAINT: return true;
        case EXECUTION_RUNTIMECONSTRAINT: return true;
        default: return false;
      }
      case EXECUTION_COLOCATIONCONSTRAINT:
      switch (other) {
        case EXECUTION_COLOCATIONCONSTRAINT: return true;
        case EXECUTION_RUNTIMECONSTRAINT: return true;
        default: return false;
      }
      case PLATFORM_PLATFORMELEM:
      switch (other) {
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_ABSTRACTSTRUCTURE:
      switch (other) {
        case PLATFORM_ABSTRACTSTRUCTURE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_DIGITALMODULE:
      switch (other) {
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_SYNTHETIZABLEDIGITALPORTS:
      switch (other) {
        case PLATFORM_SYNTHETIZABLEDIGITALPORTS: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_GENERICPROCESSINGMODULE:
      switch (other) {
        case PLATFORM_GENERICPROCESSINGMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_GENERICCOMMUNICATIONMODULE:
      switch (other) {
        case PLATFORM_GENERICCOMMUNICATIONMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_GENERICMEMORYMODULE:
      switch (other) {
        case PLATFORM_GENERICMEMORYMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_GENERICCACHEMODULE:
      switch (other) {
        case PLATFORM_GENERICCACHEMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_INSTRUMENTEDPROCESSINGMODULE:
      switch (other) {
        case PLATFORM_INSTRUMENTEDPROCESSINGMODULE: return true;
        case PLATFORM_GENERICPROCESSINGMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE:
      switch (other) {
        case PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE: return true;
        case PLATFORM_GENERICCOMMUNICATIONMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_ROUNDROBINCOMMUNICATIONMODULE:
      switch (other) {
        case PLATFORM_ROUNDROBINCOMMUNICATIONMODULE: return true;
        case PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE: return true;
        case PLATFORM_GENERICCOMMUNICATIONMODULE: return true;
        case PLATFORM_DIGITALMODULE: return true;
        case PLATFORM_PLATFORMELEM: return true;
        default: return false;
      }
      case PLATFORM_RUNTIME_ABSTRACTSCHEDULER:
      switch (other) {
        case PLATFORM_RUNTIME_ABSTRACTSCHEDULER: return true;
        default: return false;
      }
      case PLATFORM_RUNTIME_STATICCYCLICSCHEDULER:
      switch (other) {
        case PLATFORM_RUNTIME_STATICCYCLICSCHEDULER: return true;
        case PLATFORM_RUNTIME_ABSTRACTSCHEDULER: return true;
        default: return false;
      }
      case PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER:
      switch (other) {
        case PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER: return true;
        case PLATFORM_RUNTIME_ABSTRACTSCHEDULER: return true;
        default: return false;
      }
      case PLATFORM_RUNTIME_ROUNDROBINSCHEDULER:
      switch (other) {
        case PLATFORM_RUNTIME_ROUNDROBINSCHEDULER: return true;
        case PLATFORM_RUNTIME_ABSTRACTSCHEDULER: return true;
        default: return false;
      }
      case PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER:
      switch (other) {
        case PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER: return true;
        case PLATFORM_RUNTIME_ABSTRACTSCHEDULER: return true;
        default: return false;
      }
      case DECISION_ALLOCATED:
      switch (other) {
        case DECISION_ALLOCATED: return true;
        default: return false;
      }
      case DECISION_MEMORYMAPPED:
      switch (other) {
        case DECISION_MEMORYMAPPED: return true;
        case DECISION_ALLOCATED: return true;
        default: return false;
      }
      case DECISION_SCHEDULED:
      switch (other) {
        case DECISION_SCHEDULED: return true;
        default: return false;
      }
      case DECISION_SDF_PASSEDSDFCOMB:
      switch (other) {
        case DECISION_SDF_PASSEDSDFCOMB: return true;
        case MOC_SDF_SDFCOMB: return true;
        case MOC_SDF_SDFELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case DECISION_SDF_BOUNDEDSDFCHANNEL:
      switch (other) {
        case DECISION_SDF_BOUNDEDSDFCHANNEL: return true;
        case MOC_SDF_SDFCHANNEL: return true;
        case MOC_SDF_SDFELEM: return true;
        case MOC_MOCELEM: return true;
        default: return false;
      }
      case VISUALIZATION_VISUALIZABLE:
      switch (other) {
        case VISUALIZATION_VISUALIZABLE: return true;
        default: return false;
      }
      case VISUALIZATION_POSITIONED:
      switch (other) {
        case VISUALIZATION_POSITIONED: return true;
        case VISUALIZATION_VISUALIZABLE: return true;
        default: return false;
      }
      case VISUALIZATION_GREYBOX:
      switch (other) {
        case VISUALIZATION_GREYBOX: return true;
        case VISUALIZATION_VISUALIZABLE: return true;
        default: return false;
      }
      default: return false;
    }
  }

  public boolean refines(Trait other) {
    return other instanceof VertexTrait ? VertexTrait.refines(this, (VertexTrait) other) : false;
  }

  public static Trait fromName(String traitName) {
    switch (traitName) {
      case "impl::Executable":
      case "IMPL_EXECUTABLE": return VertexTrait.IMPL_EXECUTABLE;
      case "impl::InstrumentedExecutable":
      case "IMPL_INSTRUMENTEDEXECUTABLE": return VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE;
      case "moc::MoCElem":
      case "MOC_MOCELEM": return VertexTrait.MOC_MOCELEM;
      case "moc::linguafranca::LinguaFrancaElem":
      case "MOC_LINGUAFRANCA_LINGUAFRANCAELEM": return VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAELEM;
      case "moc::linguafranca::LinguaFrancaTimer":
      case "MOC_LINGUAFRANCA_LINGUAFRANCATIMER": return VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCATIMER;
      case "moc::linguafranca::LinguaFrancaReaction":
      case "MOC_LINGUAFRANCA_LINGUAFRANCAREACTION": return VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTION;
      case "moc::linguafranca::LinguaFrancaReactor":
      case "MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR": return VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCAREACTOR;
      case "moc::linguafranca::LinguaFrancaSignal":
      case "MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL": return VertexTrait.MOC_LINGUAFRANCA_LINGUAFRANCASIGNAL;
      case "moc::sdf::SDFElem":
      case "MOC_SDF_SDFELEM": return VertexTrait.MOC_SDF_SDFELEM;
      case "moc::sdf::SDFComb":
      case "MOC_SDF_SDFCOMB": return VertexTrait.MOC_SDF_SDFCOMB;
      case "moc::sdf::SDFDelay":
      case "MOC_SDF_SDFDELAY": return VertexTrait.MOC_SDF_SDFDELAY;
      case "moc::sdf::SDFChannel":
      case "MOC_SDF_SDFCHANNEL": return VertexTrait.MOC_SDF_SDFCHANNEL;
      case "execution::Stimulus":
      case "EXECUTION_STIMULUS": return VertexTrait.EXECUTION_STIMULUS;
      case "execution::PeriodicStimulus":
      case "EXECUTION_PERIODICSTIMULUS": return VertexTrait.EXECUTION_PERIODICSTIMULUS;
      case "execution::Task":
      case "EXECUTION_TASK": return VertexTrait.EXECUTION_TASK;
      case "execution::ConstrainedTask":
      case "EXECUTION_CONSTRAINEDTASK": return VertexTrait.EXECUTION_CONSTRAINEDTASK;
      case "execution::PeriodicTask":
      case "EXECUTION_PERIODICTASK": return VertexTrait.EXECUTION_PERIODICTASK;
      case "execution::Channel":
      case "EXECUTION_CHANNEL": return VertexTrait.EXECUTION_CHANNEL;
      case "execution::RuntimeConstraint":
      case "EXECUTION_RUNTIMECONSTRAINT": return VertexTrait.EXECUTION_RUNTIMECONSTRAINT;
      case "execution::PrecedenceConstraint":
      case "EXECUTION_PRECEDENCECONSTRAINT": return VertexTrait.EXECUTION_PRECEDENCECONSTRAINT;
      case "execution::ExtendedPrecedenceConstraint":
      case "EXECUTION_EXTENDEDPRECEDENCECONSTRAINT": return VertexTrait.EXECUTION_EXTENDEDPRECEDENCECONSTRAINT;
      case "execution::ColocationConstraint":
      case "EXECUTION_COLOCATIONCONSTRAINT": return VertexTrait.EXECUTION_COLOCATIONCONSTRAINT;
      case "platform::PlatformElem":
      case "PLATFORM_PLATFORMELEM": return VertexTrait.PLATFORM_PLATFORMELEM;
      case "platform::AbstractStructure":
      case "PLATFORM_ABSTRACTSTRUCTURE": return VertexTrait.PLATFORM_ABSTRACTSTRUCTURE;
      case "platform::DigitalModule":
      case "PLATFORM_DIGITALMODULE": return VertexTrait.PLATFORM_DIGITALMODULE;
      case "platform::SynthetizableDigitalPorts":
      case "PLATFORM_SYNTHETIZABLEDIGITALPORTS": return VertexTrait.PLATFORM_SYNTHETIZABLEDIGITALPORTS;
      case "platform::GenericProcessingModule":
      case "PLATFORM_GENERICPROCESSINGMODULE": return VertexTrait.PLATFORM_GENERICPROCESSINGMODULE;
      case "platform::GenericCommunicationModule":
      case "PLATFORM_GENERICCOMMUNICATIONMODULE": return VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE;
      case "platform::GenericMemoryModule":
      case "PLATFORM_GENERICMEMORYMODULE": return VertexTrait.PLATFORM_GENERICMEMORYMODULE;
      case "platform::GenericCacheModule":
      case "PLATFORM_GENERICCACHEMODULE": return VertexTrait.PLATFORM_GENERICCACHEMODULE;
      case "platform::InstrumentedProcessingModule":
      case "PLATFORM_INSTRUMENTEDPROCESSINGMODULE": return VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE;
      case "platform::InstrumentedCommunicationModule":
      case "PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE": return VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE;
      case "platform::RoundRobinCommunicationModule":
      case "PLATFORM_ROUNDROBINCOMMUNICATIONMODULE": return VertexTrait.PLATFORM_ROUNDROBINCOMMUNICATIONMODULE;
      case "platform::runtime::AbstractScheduler":
      case "PLATFORM_RUNTIME_ABSTRACTSCHEDULER": return VertexTrait.PLATFORM_RUNTIME_ABSTRACTSCHEDULER;
      case "platform::runtime::StaticCyclicScheduler":
      case "PLATFORM_RUNTIME_STATICCYCLICSCHEDULER": return VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER;
      case "platform::runtime::FixedPriorityScheduler":
      case "PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER": return VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER;
      case "platform::runtime::RoundRobinScheduler":
      case "PLATFORM_RUNTIME_ROUNDROBINSCHEDULER": return VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER;
      case "platform::runtime::TimeTriggeredScheduler":
      case "PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER": return VertexTrait.PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER;
      case "decision::Allocated":
      case "DECISION_ALLOCATED": return VertexTrait.DECISION_ALLOCATED;
      case "decision::MemoryMapped":
      case "DECISION_MEMORYMAPPED": return VertexTrait.DECISION_MEMORYMAPPED;
      case "decision::Scheduled":
      case "DECISION_SCHEDULED": return VertexTrait.DECISION_SCHEDULED;
      case "decision::sdf::PASSedSDFComb":
      case "DECISION_SDF_PASSEDSDFCOMB": return VertexTrait.DECISION_SDF_PASSEDSDFCOMB;
      case "decision::sdf::BoundedSDFChannel":
      case "DECISION_SDF_BOUNDEDSDFCHANNEL": return VertexTrait.DECISION_SDF_BOUNDEDSDFCHANNEL;
      case "visualization::Visualizable":
      case "VISUALIZATION_VISUALIZABLE": return VertexTrait.VISUALIZATION_VISUALIZABLE;
      case "visualization::Positioned":
      case "VISUALIZATION_POSITIONED": return VertexTrait.VISUALIZATION_POSITIONED;
      case "visualization::GreyBox":
      case "VISUALIZATION_GREYBOX": return VertexTrait.VISUALIZATION_GREYBOX;
      default: return new OpaqueTrait(traitName);
    }
  }

  public String getName() {
    return canonicalName;
  }
}
