package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class AllocatedViewer implements Allocated {
  public final Vertex viewedVertex;

  public AllocatedViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Allocated".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof AllocatedViewer ? ((AllocatedViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "AllocatedViewer{" + getViewedVertex().toString() + "}";
  }
}
