package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface MemoryMapped extends Allocated, VertexViewer {
  default Set<DigitalModule> getMappingHostPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "mappingHost", VertexTrait.PLATFORM_DIGITALMODULE, "outgoing").stream().map(v -> DigitalModule.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.DECISION_MEMORYMAPPED)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.DECISION_MEMORYMAPPED)) return true;
    }
    return false;
  }

  static Optional<MemoryMapped> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new MemoryMappedViewer(vertex)) : Optional.empty();
  }

  static Optional<MemoryMapped> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new MemoryMappedViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("mappingHost");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static MemoryMapped enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.DECISION_MEMORYMAPPED);
    vertex.ports.addAll(MemoryMapped.getRequiredPorts());
    for(String key : MemoryMapped.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, MemoryMapped.getRequiredProperties().get(key));
    }
    return new MemoryMappedViewer(vertex);
  }

  static MemoryMapped enforce(VertexViewer viewer) {
    return MemoryMapped.enforce(viewer.getViewedVertex());
  }
}
