package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class MemoryMappedViewer implements MemoryMapped {
  public final Vertex viewedVertex;

  public MemoryMappedViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "MemoryMapped".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof MemoryMappedViewer ? ((MemoryMappedViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "MemoryMappedViewer{" + getViewedVertex().toString() + "}";
  }
}
