package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.runtime.AbstractScheduler;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Scheduled extends VertexViewer {
  default Set<AbstractScheduler> getSchedulerPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "scheduler", VertexTrait.PLATFORM_RUNTIME_ABSTRACTSCHEDULER, "outgoing").stream().map(v -> AbstractScheduler.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.DECISION_SCHEDULED)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.DECISION_SCHEDULED)) return true;
    }
    return false;
  }

  static Optional<Scheduled> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new ScheduledViewer(vertex)) : Optional.empty();
  }

  static Optional<Scheduled> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new ScheduledViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("scheduler");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Scheduled enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.DECISION_SCHEDULED);
    vertex.ports.addAll(Scheduled.getRequiredPorts());
    for(String key : Scheduled.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Scheduled.getRequiredProperties().get(key));
    }
    return new ScheduledViewer(vertex);
  }

  static Scheduled enforce(VertexViewer viewer) {
    return Scheduled.enforce(viewer.getViewedVertex());
  }
}
