package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class ScheduledViewer implements Scheduled {
  public final Vertex viewedVertex;

  public ScheduledViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Scheduled".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof ScheduledViewer ? ((ScheduledViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "ScheduledViewer{" + getViewedVertex().toString() + "}";
  }
}
