package forsyde.io.java.typed.viewers.decision.sdf;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.moc.sdf.SDFChannel;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface BoundedSDFChannel extends SDFChannel, VertexViewer {
  /**
   * getter for required property "maximumTokens".
   * @return "maximumTokens".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getMaximumTokens() {
    return getViewedVertex().getProperties().containsKey("maximumTokens") ?
                    (Integer) getViewedVertex().getProperties().get("maximumTokens").unwrap() :
                    null;
  }

  /**
   * setter for named required property "maximumTokens".
   * @param maximumTokens value for required property "maximumTokens".
   */
  default void setMaximumTokens(Integer maximumTokens) {
    getViewedVertex().getProperties().put("maximumTokens", VertexProperty.create(maximumTokens));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.DECISION_SDF_BOUNDEDSDFCHANNEL)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.DECISION_SDF_BOUNDEDSDFCHANNEL)) return true;
    }
    return false;
  }

  static Optional<BoundedSDFChannel> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new BoundedSDFChannelViewer(vertex)) : Optional.empty();
  }

  static Optional<BoundedSDFChannel> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new BoundedSDFChannelViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static BoundedSDFChannel enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.DECISION_SDF_BOUNDEDSDFCHANNEL);
    vertex.ports.addAll(BoundedSDFChannel.getRequiredPorts());
    for(String key : BoundedSDFChannel.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, BoundedSDFChannel.getRequiredProperties().get(key));
    }
    return new BoundedSDFChannelViewer(vertex);
  }

  static BoundedSDFChannel enforce(VertexViewer viewer) {
    return BoundedSDFChannel.enforce(viewer.getViewedVertex());
  }
}
