package forsyde.io.java.typed.viewers.decision.sdf;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class BoundedSDFChannelViewer implements BoundedSDFChannel {
  public final Vertex viewedVertex;

  public BoundedSDFChannelViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "BoundedSDFChannel".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof BoundedSDFChannelViewer ? ((BoundedSDFChannelViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "BoundedSDFChannelViewer{" + getViewedVertex().toString() + "}";
  }
}
