package forsyde.io.java.typed.viewers.decision.sdf;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.moc.sdf.SDFComb;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface PASSedSDFComb extends SDFComb, VertexViewer {
  /**
   * getter for required property "firingSlots".
   * @return "firingSlots".
   * " property
   */
  @SuppressWarnings("unchecked")
  default List<Integer> getFiringSlots() {
    return getViewedVertex().getProperties().containsKey("firingSlots") ?
                    (List<Integer>) getViewedVertex().getProperties().get("firingSlots").unwrap() :
                    null;
  }

  /**
   * setter for named required property "firingSlots".
   * @param firingSlots value for required property "firingSlots".
   */
  default void setFiringSlots(List<Integer> firingSlots) {
    getViewedVertex().getProperties().put("firingSlots", VertexProperty.create(firingSlots));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.DECISION_SDF_PASSEDSDFCOMB)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.DECISION_SDF_PASSEDSDFCOMB)) return true;
    }
    return false;
  }

  static Optional<PASSedSDFComb> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new PASSedSDFCombViewer(vertex)) : Optional.empty();
  }

  static Optional<PASSedSDFComb> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new PASSedSDFCombViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static PASSedSDFComb enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.DECISION_SDF_PASSEDSDFCOMB);
    vertex.ports.addAll(PASSedSDFComb.getRequiredPorts());
    for(String key : PASSedSDFComb.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, PASSedSDFComb.getRequiredProperties().get(key));
    }
    return new PASSedSDFCombViewer(vertex);
  }

  static PASSedSDFComb enforce(VertexViewer viewer) {
    return PASSedSDFComb.enforce(viewer.getViewedVertex());
  }
}
