package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Channel extends VertexViewer {
  /**
   * getter for required property "maxElems".
   * @return "maxElems".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getMaxElems() {
    return getViewedVertex().getProperties().containsKey("maxElems") ?
                    (Integer) getViewedVertex().getProperties().get("maxElems").unwrap() :
                    null;
  }

  /**
   * setter for named required property "maxElems".
   * @param maxElems value for required property "maxElems".
   */
  default void setMaxElems(Integer maxElems) {
    getViewedVertex().getProperties().put("maxElems", VertexProperty.create(maxElems));
  }

  /**
   * getter for required property "elemSizeInBits".
   * @return "elemSizeInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getElemSizeInBits() {
    return getViewedVertex().getProperties().containsKey("elemSizeInBits") ?
                    (Long) getViewedVertex().getProperties().get("elemSizeInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "elemSizeInBits".
   * @param elemSizeInBits value for required property "elemSizeInBits".
   */
  default void setElemSizeInBits(Long elemSizeInBits) {
    getViewedVertex().getProperties().put("elemSizeInBits", VertexProperty.create(elemSizeInBits));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_CHANNEL)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_CHANNEL)) return true;
    }
    return false;
  }

  static Optional<Channel> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new ChannelViewer(vertex)) : Optional.empty();
  }

  static Optional<Channel> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new ChannelViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Channel enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_CHANNEL);
    vertex.ports.addAll(Channel.getRequiredPorts());
    for(String key : Channel.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Channel.getRequiredProperties().get(key));
    }
    return new ChannelViewer(vertex);
  }

  static Channel enforce(VertexViewer viewer) {
    return Channel.enforce(viewer.getViewedVertex());
  }
}
