package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class ChannelViewer implements Channel {
  public final Vertex viewedVertex;

  public ChannelViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Channel".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof ChannelViewer ? ((ChannelViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "ChannelViewer{" + getViewedVertex().toString() + "}";
  }
}
