package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface ColocationConstraint extends RuntimeConstraint, VertexViewer {
  default Set<Task> getCocolatedPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "cocolated", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
  }

  default Set<Task> getDislocatedPort(ForSyDeSystemGraph model) {
    return VertexAcessor.getMultipleNamedPort(model, getViewedVertex(), "dislocated", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_COLOCATIONCONSTRAINT)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.EXECUTION_COLOCATIONCONSTRAINT)) return true;
    }
    return false;
  }

  static Optional<ColocationConstraint> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new ColocationConstraintViewer(vertex)) : Optional.empty();
  }

  static Optional<ColocationConstraint> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new ColocationConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of("cocolated", "dislocated");
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static ColocationConstraint enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.EXECUTION_COLOCATIONCONSTRAINT);
    vertex.ports.addAll(ColocationConstraint.getRequiredPorts());
    for(String key : ColocationConstraint.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, ColocationConstraint.getRequiredProperties().get(key));
    }
    return new ColocationConstraintViewer(vertex);
  }

  static ColocationConstraint enforce(VertexViewer viewer) {
    return ColocationConstraint.enforce(viewer.getViewedVertex());
  }
}
